/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.utils;

import java.io.File;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.utils.ConfigContentHandler;

public class XMLParser {
    static final String SYS_PARSER_KEY = "javax.xml.parsers.SAXParserFactory";

    public static Properties getConfig(String filename) throws Exception {
        String sysConfiguredParser = System.getProperty(SYS_PARSER_KEY);
        XMLParser.setParserSystemProperty("org.apache.xerces.jaxp.SAXParserFactoryImpl");
        Properties config = null;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            SAXParser parser = factory.newSAXParser();
            ConfigContentHandler handler = new ConfigContentHandler();
            parser.parse(new File(filename), (DefaultHandler)handler);
            config = handler.getConfig();
        }
        catch (Exception e) {
            throw new LTSSystemException("Error parsing config file: " + filename, e);
        }
        finally {
            if (sysConfiguredParser != null && sysConfiguredParser.trim().length() > 1) {
                System.setProperty(SYS_PARSER_KEY, sysConfiguredParser);
            }
        }
        return config;
    }

    private static final void setParserSystemProperty(String parser) {
        System.setProperty(SYS_PARSER_KEY, parser);
    }
}

