/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.xmlparsing;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.QName;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlDocumentProcessor;
import uk.gov.hmrc.aspire.lts.xmlparsing.Utils;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlParserStax;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

class CopyingXmlDocumentProcessor
implements IXmlDocumentProcessor {
    private static final String XML_BUILDER_PROBLEM = "Problem writing to XmlBuilder";
    private final ByteArrayOutputStream os = new ByteArrayOutputStream();
    private final Map<String, String> allNamespaceMap = new HashMap<String, String>();
    private final Map<String, String> definedInternallyNamespaceMap = new HashMap<String, String>();
    private XMLBuilder builder;
    private boolean haveProcessedFirstElement;

    CopyingXmlDocumentProcessor() {
        try {
            this.builder = new XMLBuilder(Boolean.valueOf(false), (OutputStream)this.os);
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new RuntimeException("Problem creating XMLBuilder", e);
        }
    }

    @Override
    public void processStartDocumentEvent() {
    }

    @Override
    public void processStartElementEvent(QName name) {
        this.haveProcessedFirstElement = true;
        try {
            this.builder.writeStartElement(XmlParserStax.formatWithPrefix(name.getPrefix(), name.getLocalPart()));
            this.allNamespaceMap.put(name.getNamespaceURI(), name.getPrefix());
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new RuntimeException(XML_BUILDER_PROBLEM, e);
        }
    }

    @Override
    public void processAttributeEvent(QName name, String attributeName, String attributeValue) {
        if (!this.haveProcessedFirstElement) {
            return;
        }
        try {
            this.builder.writeAttribute(attributeName, attributeValue);
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new RuntimeException(XML_BUILDER_PROBLEM, e);
        }
    }

    @Override
    public void processNamespaceEvent(QName name, String prefix, String uri) {
        if (!this.haveProcessedFirstElement) {
            return;
        }
        try {
            this.builder.writeAttribute(prefix, uri);
            this.definedInternallyNamespaceMap.put(name.getNamespaceURI(), name.getPrefix());
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new RuntimeException(XML_BUILDER_PROBLEM, e);
        }
    }

    @Override
    public void processCharsEvent(QName name, String value) {
        try {
            this.builder.writeText(value);
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new RuntimeException(XML_BUILDER_PROBLEM, e);
        }
    }

    @Override
    public void processEndElementEvent(QName name) {
        try {
            this.builder.writeEndElement();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new RuntimeException(XML_BUILDER_PROBLEM, e);
        }
    }

    @Override
    public void processEndDocumentEvent() {
    }

    public String getParseResult(String enclosingTag) {
        try {
            this.builder.endDocument();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new RuntimeException("Problem calling XmlBuilder.endDocument()", e);
        }
        HashSet<String> externalNamespaces = new HashSet<String>(this.allNamespaceMap.keySet());
        externalNamespaces.removeAll(this.definedInternallyNamespaceMap.keySet());
        String result = "<" + enclosingTag;
        for (String namespace : externalNamespaces) {
            if (Utils.isEmpty(namespace)) continue;
            Object nsTag = "xmlns";
            if (Utils.isNotEmpty(this.allNamespaceMap.get(namespace))) {
                nsTag = (String)nsTag + ":" + this.allNamespaceMap.get(namespace);
            }
            result = result + " " + (String)nsTag + "=\"" + namespace + "\"";
        }
        result = result + ">\n";
        result = result + new String(this.os.toByteArray()).trim();
        return result + "\n</" + enclosingTag + ">\n";
    }
}

