/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.xmlparsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlDataProcessor;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlDocumentProcessor;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlHarvester;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlPredicate;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlStructureProcessor;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlFunctionFactory;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlPath;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlPathNode;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlPredicateFactory;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlPredicateTrue;

public class XmlDocumentProcessor
implements IXmlDocumentProcessor {
    private final XmlPathNode baseNode = new XmlPathNode();
    private XmlPathNode currentNode;
    private final List<IXmlStructureProcessor> allXmlProcessors;
    private List<List<IXmlStructureProcessor>> activeXmlProcessors;
    private final List<IXmlDocumentProcessor> listeningXmlDocumentProcessors = new ArrayList<IXmlDocumentProcessor>();
    private List<QName> currentQNamePath;

    private QName getNativeQName(QName qName) {
        String localPart = qName.getLocalPart();
        if (localPart.indexOf(91) != -1) {
            localPart = localPart.substring(0, localPart.indexOf(91));
        }
        if (localPart.indexOf(46) != -1) {
            localPart = localPart.substring(0, localPart.indexOf(46));
        }
        if (localPart.indexOf(64) != -1) {
            localPart = localPart.substring(0, localPart.indexOf(64));
        }
        return new QName(qName.getNamespaceURI(), localPart);
    }

    public XmlDocumentProcessor(IXmlHarvester[] harvesters) {
        this.allXmlProcessors = new ArrayList<IXmlHarvester>(Arrays.asList(harvesters));
        for (IXmlHarvester harvester : harvesters) {
            List<XmlPath> xmlPathList = harvester.getXmlPaths();
            for (XmlPath xmlPath : xmlPathList) {
                List<QName> qNameList = xmlPath.getQNameList();
                XmlPathNode parentNode = this.baseNode;
                IXmlPredicate predicate = new XmlPredicateTrue();
                for (int i = 0; i < qNameList.size(); ++i) {
                    IXmlDataProcessor predicateProcessor;
                    QName nativeQName = this.getNativeQName(qNameList.get(i));
                    XmlPathNode node = parentNode.getChildNodeFor(nativeQName);
                    if (node == null) {
                        node = new XmlPathNode(nativeQName, parentNode);
                    }
                    if ((predicateProcessor = XmlPredicateFactory.getPredicateProcessor(xmlPath, i + 1, predicate)) != null) {
                        node.addProcessor(predicateProcessor);
                        this.allXmlProcessors.add(predicateProcessor);
                        predicate = (IXmlPredicate)((Object)predicateProcessor);
                    }
                    if (i == qNameList.size() - 1) {
                        IXmlDataProcessor functionProcessor = XmlFunctionFactory.getFunctionProcessor(xmlPath, harvester, predicate, this);
                        node.addProcessor(functionProcessor);
                        this.allXmlProcessors.add(functionProcessor);
                    }
                    parentNode = node;
                }
            }
        }
    }

    @Override
    public void processStartDocumentEvent() {
        this.currentNode = this.baseNode;
        this.currentQNamePath = new ArrayList<QName>();
        this.activeXmlProcessors = new ArrayList<List<IXmlStructureProcessor>>();
        for (IXmlStructureProcessor xmlProcessor : this.allXmlProcessors) {
            xmlProcessor.processStartDocumentEvent();
        }
        for (IXmlDocumentProcessor listeningXmlDocumentProcessor : this.listeningXmlDocumentProcessors) {
            listeningXmlDocumentProcessor.processStartDocumentEvent();
        }
    }

    private List<IXmlStructureProcessor> getProcessors() {
        if (this.activeXmlProcessors.isEmpty()) {
            return new ArrayList<IXmlStructureProcessor>();
        }
        return this.activeXmlProcessors.get(this.activeXmlProcessors.size() - 1);
    }

    @Override
    public void processStartElementEvent(QName name) {
        this.currentQNamePath.add(name);
        ArrayList<IXmlStructureProcessor> processors = new ArrayList<IXmlStructureProcessor>();
        this.activeXmlProcessors.add(processors);
        XmlPathNode childNode = this.currentNode.getChildNodeFor(name);
        if (childNode != null) {
            this.currentNode = childNode;
            for (IXmlStructureProcessor xmlProcessor : childNode.getProcessors()) {
                processors.add(xmlProcessor);
            }
        }
        for (IXmlDocumentProcessor listeningXmlDocumentProcessor : this.listeningXmlDocumentProcessors) {
            listeningXmlDocumentProcessor.processStartElementEvent(name);
        }
        for (IXmlStructureProcessor xmlProcessor : processors) {
            xmlProcessor.processStartElementEvent(this.currentQNamePath);
        }
    }

    @Override
    public void processAttributeEvent(QName name, String attributeName, String attributeValue) {
        for (IXmlStructureProcessor xmlProcessor : this.getProcessors()) {
            if (!(xmlProcessor instanceof IXmlDataProcessor)) continue;
            ((IXmlDataProcessor)xmlProcessor).processAttributeEvent(this.currentQNamePath, attributeName, attributeValue);
        }
        for (IXmlDocumentProcessor listeningXmlDocumentProcessor : this.listeningXmlDocumentProcessors) {
            listeningXmlDocumentProcessor.processAttributeEvent(name, attributeName, attributeValue);
        }
    }

    @Override
    public void processNamespaceEvent(QName name, String prefix, String uri) {
        for (IXmlDocumentProcessor listeningXmlDocumentProcessor : this.listeningXmlDocumentProcessors) {
            listeningXmlDocumentProcessor.processNamespaceEvent(name, prefix, uri);
        }
    }

    @Override
    public void processCharsEvent(QName name, String value) {
        for (IXmlStructureProcessor xmlProcessor : this.getProcessors()) {
            if (!(xmlProcessor instanceof IXmlDataProcessor)) continue;
            ((IXmlDataProcessor)xmlProcessor).processCharsEvent(this.currentQNamePath, value);
        }
        for (IXmlDocumentProcessor listeningXmlDocumentProcessor : this.listeningXmlDocumentProcessors) {
            listeningXmlDocumentProcessor.processCharsEvent(name, value);
        }
    }

    @Override
    public void processEndElementEvent(QName name) {
        List<IXmlStructureProcessor> processors = this.getProcessors();
        for (int i = processors.size() - 1; i >= 0; --i) {
            IXmlStructureProcessor xmlProcessor = processors.get(i);
            xmlProcessor.processEndElementEvent(this.currentQNamePath);
        }
        if (this.currentNode.isNodeFor(name)) {
            this.currentNode = this.currentNode.getParentNode();
        }
        this.activeXmlProcessors.remove(this.activeXmlProcessors.size() - 1);
        this.currentQNamePath.remove(this.currentQNamePath.size() - 1);
        for (IXmlDocumentProcessor listeningXmlDocumentProcessor : this.listeningXmlDocumentProcessors) {
            listeningXmlDocumentProcessor.processEndElementEvent(name);
        }
    }

    @Override
    public void processEndDocumentEvent() {
        for (int i = this.allXmlProcessors.size() - 1; i >= 0; --i) {
            IXmlStructureProcessor xmlProcessor = this.allXmlProcessors.get(i);
            xmlProcessor.processEndDocumentEvent();
        }
        for (IXmlDocumentProcessor listeningXmlDocumentProcessor : this.listeningXmlDocumentProcessors) {
            listeningXmlDocumentProcessor.processEndDocumentEvent();
        }
    }

    public void deregisterCopyingXmlDocumentProcessor(IXmlDocumentProcessor copyingXmlDocumentProcessor) {
        this.listeningXmlDocumentProcessors.remove(copyingXmlDocumentProcessor);
    }

    public void registerCopyingXmlDocumentProcessor(IXmlDocumentProcessor copyingXmlDocumentProcessor) {
        this.listeningXmlDocumentProcessors.add(copyingXmlDocumentProcessor);
    }
}

