/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.xmlparsing;

import java.util.List;
import javax.xml.namespace.QName;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlDataProcessor;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlHarvester;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlPredicate;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlDocumentProcessor;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlFunctionAttribute;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlFunctionCSV;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlFunctionCopy;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlFunctionCount;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlFunctionName;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlFunctionNamespace;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlFunctionNotifyEndElement;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlFunctionNotifyStartElement;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlFunctionText;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlPath;

public final class XmlFunctionFactory {
    public static final String UNKNOWN_XML_FUNCTION = "XmlPath contains unknown function: ";
    public static final String UNCLOSED_XML_FUNCTION = "XmlPath contains '(' with no closing ')': ";

    private XmlFunctionFactory() {
    }

    public static IXmlDataProcessor getFunctionProcessor(XmlPath xmlPathForHarvester, IXmlHarvester harvester, IXmlPredicate parentPredicate, XmlDocumentProcessor xmlDocumentProcessor) {
        List<QName> qNameList = xmlPathForHarvester.getQNameList();
        String localPart = qNameList.get(qNameList.size() - 1).getLocalPart();
        if (localPart.contains("(") && !localPart.contains(")")) {
            throw new RuntimeException(UNCLOSED_XML_FUNCTION + localPart);
        }
        if (localPart.contains("@") && !localPart.contains("[@")) {
            return new XmlFunctionAttribute(localPart.substring(localPart.indexOf(64) + 1), harvester, xmlPathForHarvester, parentPredicate);
        }
        if (!localPart.contains(".") || localPart.contains(".text()")) {
            return new XmlFunctionText(harvester, xmlPathForHarvester, parentPredicate);
        }
        if (localPart.contains(".csv()")) {
            return new XmlFunctionCSV(harvester, xmlPathForHarvester, parentPredicate);
        }
        if (localPart.contains(".copy(")) {
            String params = localPart.substring(localPart.indexOf(40) + 1, localPart.indexOf(41)).trim();
            return new XmlFunctionCopy(harvester, xmlPathForHarvester, parentPredicate, params, xmlDocumentProcessor);
        }
        if (localPart.contains(".nodename()")) {
            return new XmlFunctionName(harvester, xmlPathForHarvester, parentPredicate);
        }
        if (localPart.contains(".namespace()")) {
            return new XmlFunctionNamespace(harvester, xmlPathForHarvester, parentPredicate);
        }
        if (localPart.contains(".count()")) {
            return new XmlFunctionCount(harvester, xmlPathForHarvester, parentPredicate);
        }
        if (localPart.contains(".notifyStart()")) {
            return new XmlFunctionNotifyStartElement(harvester, xmlPathForHarvester, parentPredicate);
        }
        if (localPart.contains(".notifyEnd()")) {
            return new XmlFunctionNotifyEndElement(harvester, xmlPathForHarvester, parentPredicate);
        }
        throw new RuntimeException(UNKNOWN_XML_FUNCTION + localPart);
    }
}

