/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.xmlparsing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlHarvester;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlPath;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlStructureProcessor;

public class XmlHarvester
extends XmlStructureProcessor
implements IXmlHarvester {
    private Map<String, String> harvestedData;
    private final Map<XmlPath, String> xmlPathToNameMap;

    public XmlHarvester(Map<XmlPath, String> xmlPathToNameMap) {
        this.xmlPathToNameMap = xmlPathToNameMap;
        this.resetHarvestedData();
    }

    @Override
    public void processData(XmlPath key, String value) {
        String attributeName = this.xmlPathToNameMap.get(key);
        if (attributeName != null) {
            if (this.harvestedData.containsKey(attributeName)) {
                this.harvestedData.put(attributeName, this.harvestedData.get(attributeName) + value);
            } else {
                this.harvestedData.put(attributeName, value);
            }
        }
    }

    @Override
    public List<XmlPath> getXmlPaths() {
        return new ArrayList<XmlPath>(this.xmlPathToNameMap.keySet());
    }

    @Override
    public Map<String, String> getHarvestedData() {
        return this.harvestedData;
    }

    protected final void resetHarvestedData() {
        this.harvestedData = new HashMap<String, String>();
    }
}

