/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.xmlparsing;

import java.util.HashMap;
import java.util.Map;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlHarvester;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlHarvester;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlPath;

public class XmlHarvesterFactory {
    private Map<String, String> namespaceMap;
    private final Map<XmlPath, String> harvestMap = new HashMap<XmlPath, String>();
    private final Map<String, Map<XmlPath, String>> messageClassHarvestMap = new HashMap<String, Map<XmlPath, String>>();

    public void setNamespaceMap(Map<String, String> namespaceMap) {
        this.namespaceMap = namespaceMap;
    }

    public void setHarvestMap(Map<String, String> harvestStrMap) {
        for (String xmlPathString : harvestStrMap.keySet()) {
            this.harvestMap.put(new XmlPath(xmlPathString, this.namespaceMap), harvestStrMap.get(xmlPathString));
        }
    }

    public void setMessageClassHarvestMap(Map<String, Map<String, String>> messageClassHarvestStrMap) {
        for (String messageClass : messageClassHarvestStrMap.keySet()) {
            HashMap<XmlPath, String> localHarvestMap = new HashMap<XmlPath, String>();
            this.messageClassHarvestMap.put(messageClass, localHarvestMap);
            Map<String, String> harvestStrMap = messageClassHarvestStrMap.get(messageClass);
            for (String xmlPathString : harvestStrMap.keySet()) {
                localHarvestMap.put(new XmlPath(xmlPathString, this.namespaceMap), harvestStrMap.get(xmlPathString));
            }
        }
    }

    public IXmlHarvester create(String messageClass) {
        HashMap<XmlPath, String> map = new HashMap<XmlPath, String>(this.harvestMap);
        if (this.messageClassHarvestMap.get(messageClass) != null) {
            map.putAll(this.messageClassHarvestMap.get(messageClass));
        }
        return new XmlHarvester(map);
    }
}

