/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.xmlparsing;

import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlDocumentProcessor;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlDocumentProcessorFactory;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlHarvester;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlParser;
import uk.gov.hmrc.aspire.lts.xmlparsing.Utils;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlDocumentProcessorFactory;

public class XmlParserStax
implements IXmlParser {
    private static final XMLInputFactory XML_INPUT_FACTORY = XmlParserStax.createXmlInputFactory();
    private static final String UTF_8 = "UTF-8";
    private IXmlDocumentProcessorFactory xmlDocumentProcessorFactory = new XmlDocumentProcessorFactory();

    private static XMLInputFactory createXmlInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        return factory;
    }

    public void setXmlDocumentProcessorFactory(IXmlDocumentProcessorFactory xmlDocumentProcessorFactory) {
        this.xmlDocumentProcessorFactory = xmlDocumentProcessorFactory;
    }

    private XMLEventReader createXMLEventReader(InputStream inputStream) {
        XMLInputFactory xMLInputFactory = XML_INPUT_FACTORY;
        synchronized (xMLInputFactory) {
            try {
                return XML_INPUT_FACTORY.createXMLEventReader(inputStream, UTF_8);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Problem creating XMLEventReader", e);
            }
        }
    }

    private void closeEventReader(XMLEventReader eventReader) {
        try {
            eventReader.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Problem closing XMLEventReader", e);
        }
    }

    public static String formatWithPrefix(String prefix, String localName) {
        if (Utils.isNotEmpty(prefix)) {
            return prefix + ":" + localName;
        }
        return localName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream inputStream, IXmlHarvester ... xmlHarvesters) {
        XMLEventReader eventReader = null;
        try {
            eventReader = this.createXMLEventReader(inputStream);
            IXmlDocumentProcessor xmlDocumentProcessor = this.xmlDocumentProcessorFactory.create(xmlHarvesters);
            QName currentElementName = null;
            while (eventReader.hasNext()) {
                XMLEvent event = (XMLEvent)eventReader.next();
                int eventType = event.getEventType();
                switch (eventType) {
                    case 7: {
                        xmlDocumentProcessor.processStartDocumentEvent();
                        break;
                    }
                    case 1: {
                        currentElementName = this.dealWithStartElement(event, xmlDocumentProcessor);
                        break;
                    }
                    case 4: {
                        xmlDocumentProcessor.processCharsEvent(currentElementName, event.asCharacters().getData());
                        break;
                    }
                    case 2: {
                        currentElementName = null;
                        xmlDocumentProcessor.processEndElementEvent(event.asEndElement().getName());
                        break;
                    }
                    case 8: {
                        xmlDocumentProcessor.processEndDocumentEvent();
                        break;
                    }
                }
            }
        }
        finally {
            if (eventReader != null) {
                this.closeEventReader(eventReader);
            }
        }
    }

    private QName dealWithStartElement(XMLEvent event, IXmlDocumentProcessor xmlDocumentProcessor) {
        QName currentElementName = event.asStartElement().getName();
        xmlDocumentProcessor.processStartElementEvent(event.asStartElement().getName());
        Iterator<Attribute> attrIterator = event.asStartElement().getAttributes();
        while (attrIterator.hasNext()) {
            Attribute attribute = attrIterator.next();
            xmlDocumentProcessor.processAttributeEvent(currentElementName, XmlParserStax.formatWithPrefix(attribute.getName().getPrefix(), attribute.getName().getLocalPart()), attribute.getValue());
        }
        Iterator<Namespace> namespaceIterator = event.asStartElement().getNamespaces();
        while (namespaceIterator.hasNext()) {
            Namespace namespace = namespaceIterator.next();
            xmlDocumentProcessor.processNamespaceEvent(currentElementName, XmlParserStax.formatWithPrefix(namespace.getName().getPrefix(), namespace.getName().getLocalPart()), namespace.getValue());
        }
        return currentElementName;
    }
}

