/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.xmlparsing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class XmlPath {
    static final String BAD_XML_PATH = "XmlPath must start with '/' but was ";
    static final String NAMESPACE_MISSING = "Namespace element missing from ";
    static final String NAMESPACE_UNDEFINED = " couldn't be built because of undefined namespace ";
    private final List<QName> qNameList;

    public XmlPath(List<QName> xmlPath) {
        this.qNameList = xmlPath;
    }

    public XmlPath(String xmlPathAsString, Map<String, String> namespaceMap) {
        String[] paths;
        if (!xmlPathAsString.startsWith("/")) {
            throw new RuntimeException(BAD_XML_PATH + xmlPathAsString);
        }
        this.qNameList = new ArrayList<QName>();
        for (String path : paths = xmlPathAsString.substring(1).split("/")) {
            String namespace = "";
            if (!path.contains(":")) {
                throw new RuntimeException(NAMESPACE_MISSING + xmlPathAsString);
            }
            String ns = path.substring(0, path.indexOf(58)).trim();
            if (!namespaceMap.containsKey(ns)) {
                throw new RuntimeException(xmlPathAsString + NAMESPACE_UNDEFINED + ns);
            }
            namespace = namespaceMap.get(ns);
            path = path.substring(path.indexOf(58) + 1);
            this.qNameList.add(new QName(namespace, path.trim()));
        }
    }

    public List<QName> getQNameList() {
        return this.qNameList;
    }

    public boolean matches(List<QName> otherQNameList) {
        if (this.qNameList.size() != otherQNameList.size()) {
            return false;
        }
        for (int i = 0; i < this.qNameList.size(); ++i) {
            if (this.qNameList.get(i).equals(otherQNameList.get(i))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.qNameList.hashCode();
    }
}

