/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.xmlparsing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlStructureProcessor;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlStructureProcessorComparator;

public class XmlPathNode {
    private QName qName;
    private final XmlPathNode parentNode;
    private final Set<XmlPathNode> childNodes;
    private final List<IXmlStructureProcessor> processors;

    XmlPathNode() {
        this.parentNode = null;
        this.childNodes = new HashSet<XmlPathNode>();
        this.processors = new ArrayList<IXmlStructureProcessor>();
    }

    public XmlPathNode(QName qName, XmlPathNode parentNode) {
        this.qName = qName;
        this.parentNode = parentNode;
        this.childNodes = new HashSet<XmlPathNode>();
        this.processors = new ArrayList<IXmlStructureProcessor>();
        if (parentNode != null) {
            parentNode.childNodes.add(this);
        }
    }

    public XmlPathNode getChildNodeFor(QName childQName) {
        for (XmlPathNode childNode : this.childNodes) {
            if (!childNode.qName.equals(childQName)) continue;
            return childNode;
        }
        return null;
    }

    public boolean isNodeFor(QName name) {
        return name.equals(this.qName);
    }

    public void addProcessor(IXmlStructureProcessor processor) {
        this.processors.add(processor);
        Collections.sort(this.processors, new XmlStructureProcessorComparator());
    }

    protected XmlPathNode getParentNode() {
        return this.parentNode;
    }

    protected List<IXmlStructureProcessor> getProcessors() {
        return this.processors;
    }
}

