/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.xmlparsing;

import java.util.List;
import javax.xml.namespace.QName;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlPredicate;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlDataProcessor;

public class XmlPredicateAttributeValueMatch
extends XmlDataProcessor
implements IXmlPredicate {
    public static final String BAD_FORMAT = "Attribute match needs format @name='value' but was: ";
    private final String attributeName;
    private final String attributeValue;
    private int matchingNameLength;

    public XmlPredicateAttributeValueMatch(String predicate, IXmlPredicate parentPredicate) {
        super(parentPredicate);
        if (predicate.indexOf(61) < 1) {
            throw new RuntimeException(BAD_FORMAT + predicate);
        }
        this.attributeName = predicate.substring(1, predicate.indexOf(61)).trim();
        String attrVal = predicate.substring(predicate.indexOf(61) + 1).trim();
        if (!attrVal.startsWith("'") || !attrVal.endsWith("'") || attrVal.length() <= 2) {
            throw new RuntimeException(BAD_FORMAT + predicate);
        }
        attrVal = attrVal.substring(1, attrVal.length() - 1);
        this.attributeValue = attrVal;
    }

    @Override
    public void processAttributeEvent(List<QName> name, String attrName, String attrValue) {
        if (this.isParentPredicateMatched() && this.attributeName.equals(attrName) && this.attributeValue.equals(attrValue)) {
            this.matchingNameLength = name.size();
        }
    }

    @Override
    public void processEndElementEvent(List<QName> name) {
        if (this.matchingNameLength > 0 && name.size() == this.matchingNameLength) {
            this.matchingNameLength = 0;
        }
    }

    @Override
    public boolean isMatched() {
        return this.matchingNameLength > 0;
    }
}

