/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.xmlparsing;

import java.util.List;
import javax.xml.namespace.QName;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlDataProcessor;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlPredicate;
import uk.gov.hmrc.aspire.lts.xmlparsing.Utils;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlPath;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlPredicateAttributeValueMatch;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlPredicateNodeInstanceMatch;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlPredicateNodeValueMatch;

public final class XmlPredicateFactory {
    public static final String UNCLOSED_XML_PREDICATE = "XmlPath contains '[' with no closing ']': ";

    private XmlPredicateFactory() {
    }

    public static IXmlDataProcessor getPredicateProcessor(XmlPath xmlPath, int index, IXmlPredicate parentPredicate) {
        List<QName> qNameList = xmlPath.getQNameList();
        String localPart = qNameList.get(index - 1).getLocalPart();
        if (!localPart.contains("[")) {
            return null;
        }
        if (!localPart.contains("]")) {
            throw new RuntimeException(UNCLOSED_XML_PREDICATE + localPart);
        }
        String predicate = localPart.substring(localPart.indexOf(91) + 1, localPart.indexOf(93)).trim();
        if (Utils.isNumeric(predicate)) {
            return new XmlPredicateNodeInstanceMatch(index, predicate, parentPredicate);
        }
        if (predicate.startsWith("@")) {
            return new XmlPredicateAttributeValueMatch(predicate, parentPredicate);
        }
        return new XmlPredicateNodeValueMatch(predicate, parentPredicate);
    }
}

