/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.xmlparsing;

import java.util.List;
import javax.xml.namespace.QName;
import uk.gov.hmrc.aspire.lts.xmlparsing.IXmlPredicate;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlDataProcessor;

public class XmlPredicateNodeValueMatch
extends XmlDataProcessor
implements IXmlPredicate {
    public static final String BAD_FORMAT = "Node match needs format name='value' but was: ";
    private final String nodeName;
    private final String nodeText;
    private int matchingNameLength;

    public XmlPredicateNodeValueMatch(String predicate, IXmlPredicate parentPredicate) {
        super(parentPredicate);
        if (predicate.indexOf(61) < 1) {
            throw new RuntimeException(BAD_FORMAT + predicate);
        }
        this.nodeName = predicate.substring(0, predicate.indexOf(61)).trim();
        String value = predicate.substring(predicate.indexOf(61) + 1).trim();
        if (!value.startsWith("'") || !value.endsWith("'") || value.length() <= 2) {
            throw new RuntimeException(BAD_FORMAT + predicate);
        }
        this.nodeText = value.substring(1, value.length() - 1);
    }

    @Override
    public void processCharsEvent(List<QName> name, String value) {
        QName lastQName = name.get(name.size() - 1);
        if (this.isParentPredicateMatched() && this.nodeName.equals(lastQName.getLocalPart()) && this.nodeText.equals(value)) {
            this.matchingNameLength = name.size();
        }
    }

    @Override
    public void processEndElementEvent(List<QName> name) {
        if (this.matchingNameLength > 0 && name.size() == this.matchingNameLength) {
            this.matchingNameLength = 0;
        }
    }

    @Override
    public boolean isMatched() {
        return this.matchingNameLength > 0;
    }
}

