/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.httpclient;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class GenericValidatorHTTPClient {
    public static final String DEFAULT_LTS_URL = "http://localhost:5665/LTS";
    private static final String LINE_END = "\r\n";
    private static final String TWO_HYPHENS = "--";
    private static final String BOUNDARY = "*****";
    private File destDirectory;

    public GenericValidatorHTTPClient(String destDirectory) {
        this.setDestDirectory(destDirectory);
    }

    private static void closeInputStream(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ioe) {
            System.err.println("Exception while trying to close InputStream:");
            ioe.printStackTrace(System.err);
        }
    }

    private static void closeOutputStream(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException ioe) {
            System.err.println("Exception while trying to close OutputStream:");
            ioe.printStackTrace(System.err);
        }
    }

    private static boolean isXML(File file) {
        boolean isXML = false;
        String filename = file.getName();
        int extensionIndex = filename.lastIndexOf(".");
        if (extensionIndex != -1 && extensionIndex < filename.length()) {
            isXML = "xml".equalsIgnoreCase(filename.substring(extensionIndex + 1));
        }
        return isXML;
    }

    private static HttpURLConnection getConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "multipart/form-data;boundary=*****");
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File[] file;
        String sourceDirectory = null;
        String destDirectory = null;
        URL url = null;
        try {
            sourceDirectory = args[0];
            destDirectory = args[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            GenericValidatorHTTPClient.usage();
            System.exit(0);
        }
        try {
            url = args.length > 2 && args[2] != null && args[2].trim().length() > 0 ? new URL(args[2] + "/LTSServlet") : new URL("http://localhost:5665/LTS/LTSServlet");
        }
        catch (MalformedURLException murle) {
            System.err.println("URL is malformed: " + args[2]);
            GenericValidatorHTTPClient.usage();
            System.exit(0);
        }
        System.out.println("===================================================================================");
        System.out.println("Starting GeneticValidatorHTTPClient...");
        if (!new File(sourceDirectory).isDirectory()) {
            System.err.println("Source directory does not exist or is not a directory: " + sourceDirectory);
            GenericValidatorHTTPClient.usage();
            System.exit(0);
        }
        if ((file = new File(sourceDirectory).listFiles()).length == 0) {
            System.err.println("There are no files in the source directory to validate: " + sourceDirectory);
            System.exit(0);
        }
        try {
            GenericValidatorHTTPClient client = null;
            try {
                client = new GenericValidatorHTTPClient(destDirectory);
            }
            catch (IllegalArgumentException iae) {
                System.err.println(iae.getMessage());
                GenericValidatorHTTPClient.usage();
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.exit(0);
            }
            HttpURLConnection connection = null;
            for (int i = 0; i < file.length; ++i) {
                if (file[i].isDirectory()) {
                    System.out.println("File " + file[i].getAbsolutePath() + " is a directory in the source directory and will not be processed");
                    continue;
                }
                if (!GenericValidatorHTTPClient.isXML(file[i])) {
                    System.out.println("File " + file[i].getAbsolutePath() + " is not an XML file and will not be processed");
                    continue;
                }
                try {
                    connection = GenericValidatorHTTPClient.getConnection(url);
                    client.upload(file[i], connection);
                    continue;
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.disconnect();
                            connection = null;
                        }
                        catch (Exception e) {
                            System.err.println("Exception while trying to disconnect the HttpURLConnection:");
                            e.printStackTrace(System.err);
                        }
                    }
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("Problem with the connection to the Live Test Service:");
            ioe.printStackTrace(System.err);
        }
        System.out.println("Exiting GeneticValidatorHTTPClient, Check the directory '" + destDirectory + "' for (possible) validation results.");
        System.out.println("===================================================================================");
    }

    public void setDestDirectory(String destDirectory) {
        if (destDirectory == null) {
            throw new NullPointerException("destDirectory");
        }
        this.destDirectory = new File(destDirectory).getAbsoluteFile();
        if (!this.destDirectory.exists() || !this.destDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination directory does not exist or is not a directory: " + destDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(File fileToValidate, HttpURLConnection conn) {
        block12: {
            int bytesRead;
            if (fileToValidate == null) {
                throw new RuntimeException("File to Validate is unspecified");
            }
            DataOutputStream dataOut = null;
            FileInputStream fileInputStream = null;
            int maxBufferSize = 0x100000;
            try {
                fileInputStream = new FileInputStream(fileToValidate);
                dataOut = new DataOutputStream(conn.getOutputStream());
                dataOut.writeBytes("--*****\r\n");
                dataOut.writeBytes("Content-Disposition: form-data; name=\"upload\"; filename=\"" + fileToValidate.getName() + "\"\r\n");
                dataOut.writeBytes(LINE_END);
                int bytesAvailable = fileInputStream.available();
                int bufferSize = Math.min(bytesAvailable, maxBufferSize);
                byte[] buffer = new byte[bufferSize];
                bytesRead = fileInputStream.read(buffer, 0, bufferSize);
                while (bytesRead > 0) {
                    dataOut.write(buffer, 0, bufferSize);
                    bytesAvailable = fileInputStream.available();
                    bufferSize = Math.min(bytesAvailable, maxBufferSize);
                    bytesRead = fileInputStream.read(buffer, 0, bufferSize);
                }
                dataOut.writeBytes(LINE_END);
                dataOut.writeBytes("--*****--\r\n");
                dataOut.flush();
            }
            catch (IOException ioe) {
                try {
                    System.err.println("From GenericValidatorHTTPClient Client Request Failed , due to  :" + String.valueOf(ioe));
                }
                catch (Throwable throwable) {
                    GenericValidatorHTTPClient.closeInputStream(fileInputStream);
                    GenericValidatorHTTPClient.closeOutputStream(dataOut);
                    throw throwable;
                }
                GenericValidatorHTTPClient.closeInputStream(fileInputStream);
                GenericValidatorHTTPClient.closeOutputStream(dataOut);
            }
            GenericValidatorHTTPClient.closeInputStream(fileInputStream);
            GenericValidatorHTTPClient.closeOutputStream(dataOut);
            InputStream in = null;
            BufferedOutputStream out = null;
            try {
                in = conn.getInputStream();
                out = new BufferedOutputStream(new FileOutputStream(new File(this.destDirectory, "vld_" + fileToValidate.getName())));
                byte[] bytes = new byte[1024];
                bytesRead = 0;
                while ((bytesRead = in.read(bytes)) != -1) {
                    ((OutputStream)out).write(bytes, 0, bytesRead);
                }
                System.out.println("\t" + fileToValidate.getName() + " processed ! ");
                GenericValidatorHTTPClient.closeInputStream(in);
            }
            catch (IOException ioex) {
                System.err.println("From GenericValidatorHTTPClient Server Response Failed , due to " + String.valueOf(ioex));
                break block12;
            }
            finally {
                GenericValidatorHTTPClient.closeInputStream(in);
                GenericValidatorHTTPClient.closeOutputStream(out);
            }
            GenericValidatorHTTPClient.closeOutputStream(out);
        }
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("       java GenericValidatorHTTPClient sourceDirectory destinationDirectory [url]");
        System.out.println("sourceDirectory      - path to the folder containing the submission files to");
        System.out.println("                       upload to the LTS.");
        System.out.println("destinationDirectory - path to the folder in which to place the responses");
        System.out.println("                       from the LTS.");
        System.out.println("url                  - the URL, up to and including the context root, used to");
        System.out.println("                       connect to the LTS.");
        System.out.println("                       E.g. \"http://localhost:5665/LTS\"");
        System.out.println("                       Note: the above example is used as the default value");
        System.out.println("                       when this argument is not supplied.");
    }
}

