/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.exslt;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTimeFunctions {
    static final String dt = "yyyy-MM-dd'T'HH:mm:ss";
    static final String d = "yyyy-MM-dd";
    static final String gym = "yyyy-MM";
    static final String gy = "yyyy";
    static final String gmd = "--MM-dd";
    static final String gm = "--MM--";
    static final String gd = "---dd";
    static final String t = "HH:mm:ss";
    static final String EMPTY_STR = "";
    static final int DURATION_SIGN_INDX = 1;
    static final int DURATION_YEAR_INDX = 3;
    static final int DURATION_MONTH_INDX = 4;
    static final int DURATION_DAY_INDX = 5;
    static final int DURATION_HOUR_INDX = 7;
    static final int DURATION_MINUTE_INDX = 8;
    static final int DURATION_SECOND_INDX = 9;

    public static String add(String datetimeIn, String duration) {
        String fmt = DateTimeFunctions.getFormat(datetimeIn);
        if (fmt.equals(EMPTY_STR)) {
            return EMPTY_STR;
        }
        String regEx = "(-)?(P)([0-9]+Y)?([0-9]+M)?([0-9]+D)?(T)?([0-9]+H)?([0-9]+M)?([0-9]+S)?";
        String[] durationParts = DateTimeFunctions.parseDuration(duration, regEx);
        if (durationParts == null) {
            return EMPTY_STR;
        }
        SimpleDateFormat sdf = null;
        Calendar cal = Calendar.getInstance();
        try {
            sdf = new SimpleDateFormat(fmt);
            cal.setTime(sdf.parse(datetimeIn));
            if (durationParts[9] != null) {
                cal.add(13, DateTimeFunctions.getDuration(durationParts, 9));
            }
            if (durationParts[8] != null) {
                cal.add(12, DateTimeFunctions.getDuration(durationParts, 8));
            }
            if (durationParts[7] != null) {
                cal.add(10, DateTimeFunctions.getDuration(durationParts, 7));
            }
            if (durationParts[5] != null) {
                cal.add(5, DateTimeFunctions.getDuration(durationParts, 5));
            }
            if (durationParts[4] != null) {
                cal.add(2, DateTimeFunctions.getDuration(durationParts, 4));
            }
            if (durationParts[3] != null) {
                cal.add(1, DateTimeFunctions.getDuration(durationParts, 3));
            }
        }
        catch (ParseException pe) {
            Logger.global.info("ParseException: " + pe.getMessage());
            return EMPTY_STR;
        }
        return sdf.format(cal.getTime());
    }

    public static String addDuration(String duration1, String duration2) {
        return DateTimeFunctions.addDurationV1(duration1, duration2);
    }

    public static String addDurationV1(String duration1, String duration2) {
        String regEx = "(-)?(P)([0-9]+Y)?([0-9]+M)?([0-9]+D)?(T)?([0-9]+H)?([0-9]+M)?([0-9]+S)?";
        String[] durationParts1 = DateTimeFunctions.parseDuration(duration1, regEx);
        if (durationParts1 == null) {
            return EMPTY_STR;
        }
        String[] durationParts2 = DateTimeFunctions.parseDuration(duration2, regEx);
        if (durationParts2 == null) {
            return EMPTY_STR;
        }
        if (durationParts1[1] == null && durationParts2[1] != null) {
            return EMPTY_STR;
        }
        if (durationParts2[1] == null && durationParts1[1] != null) {
            return EMPTY_STR;
        }
        String sign = durationParts1[1] == null ? EMPTY_STR : "-";
        int years = DateTimeFunctions.getDuration(durationParts1, 3) + DateTimeFunctions.getDuration(durationParts2, 3);
        int months = DateTimeFunctions.getDuration(durationParts1, 4) + DateTimeFunctions.getDuration(durationParts2, 4);
        int days = DateTimeFunctions.getDuration(durationParts1, 5) + DateTimeFunctions.getDuration(durationParts2, 5);
        int hours = DateTimeFunctions.getDuration(durationParts1, 7) + DateTimeFunctions.getDuration(durationParts2, 7);
        int minutes = DateTimeFunctions.getDuration(durationParts1, 8) + DateTimeFunctions.getDuration(durationParts2, 8);
        int seconds = DateTimeFunctions.getDuration(durationParts1, 9) + DateTimeFunctions.getDuration(durationParts2, 9);
        StringBuffer sb = new StringBuffer();
        sb.append(sign);
        sb.append("P");
        if (years != 0) {
            sb.append(Math.abs(years));
            sb.append("Y");
        }
        if (months != 0) {
            sb.append(Math.abs(months));
            sb.append("M");
        }
        if (days != 0) {
            sb.append(Math.abs(days));
            sb.append("D");
        }
        if (hours + minutes + seconds != 0) {
            sb.append("T");
            if (hours != 0) {
                sb.append(Math.abs(hours));
                sb.append("H");
            }
            if (minutes != 0) {
                sb.append(Math.abs(minutes));
                sb.append("M");
            }
            if (seconds != 0) {
                sb.append(Math.abs(seconds));
                sb.append("S");
            }
        }
        return sb.toString();
    }

    private static String[] parseDuration(String duration, String regEx) {
        String[] durationParts = null;
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(duration);
        if (m.find()) {
            durationParts = new String[m.groupCount() + 1];
            int i = 0;
            while (i <= m.groupCount()) {
                durationParts[i] = m.group(i);
                ++i;
            }
        }
        return durationParts;
    }

    private static int getDuration(String[] durationParts, int index) {
        if (durationParts[index] == null) {
            return 0;
        }
        boolean isNegative = false;
        if (durationParts[1] != null && durationParts[1].equals("-")) {
            isNegative = true;
        }
        int time = Integer.parseInt(durationParts[index].substring(0, durationParts[index].length() - 1));
        if (isNegative) {
            return time * -1;
        }
        return time;
    }

    public static String difference(String date1, String date2) {
        String fmt1 = DateTimeFunctions.getFormat(date1);
        if (fmt1.equals(EMPTY_STR)) {
            return fmt1;
        }
        String fmt2 = DateTimeFunctions.getFormat(date2);
        if (fmt2.equals(EMPTY_STR)) {
            return fmt2;
        }
        String fmtLeastSpecific = date1.length() < date2.length() ? DateTimeFunctions.getFormat(date1) : DateTimeFunctions.getFormat(date2);
        long diffMil = 0L;
        try {
            diffMil = new SimpleDateFormat(fmt2).parse(date2).getTime() - new SimpleDateFormat(fmt1).parse(date1).getTime();
        }
        catch (ParseException pe) {
            Logger.global.info("ParseException: " + pe.getMessage());
            return EMPTY_STR;
        }
        if (fmtLeastSpecific.equals(gym) || fmtLeastSpecific.equals(gy)) {
            return DateTimeFunctions.formatDuration(diffMil, true);
        }
        return DateTimeFunctions.formatDuration(diffMil, false);
    }

    public static String duration(String seconds) {
        long secs = 0L;
        try {
            secs = Long.parseLong(seconds);
        }
        catch (Exception e) {
            Logger.global.info("ParseException: " + e.getMessage());
            return EMPTY_STR;
        }
        return DateTimeFunctions.formatDuration(secs * 1000L, false);
    }

    public static String duration() {
        long secs = new Date().getTime() / 1000L;
        return DateTimeFunctions.duration(String.valueOf(secs));
    }

    private static String formatDuration(long diffMil, boolean isYearMonthFormatOnly) {
        long giYearMill = 31536000000L;
        long giMonthMill = 2592000000L;
        long giDayMill = 86400000L;
        long giHourMill = 3600000L;
        long giMinMill = 60000L;
        long giSecMill = 1000L;
        long y = 0L;
        long m = 0L;
        long d = 0L;
        long h = 0L;
        long n = 0L;
        long s = 0L;
        String pm = diffMil < 0L ? "-" : EMPTY_STR;
        diffMil = Math.abs(diffMil);
        if (isYearMonthFormatOnly) {
            y = (long)Math.floor(diffMil / 31536000000L);
            m = (long)Math.floor(diffMil % 31536000000L / 2592000000L);
        } else {
            d = (long)Math.floor(diffMil / 86400000L);
            h = (long)Math.floor(diffMil % 86400000L / 3600000L);
            n = (long)Math.floor(diffMil % 3600000L / 60000L);
            s = (long)Math.floor(diffMil % 60000L / 1000L) + diffMil % 1000L / 1000L;
        }
        return String.valueOf(pm) + "P" + (y != 0L ? String.valueOf(y) + "Y" : EMPTY_STR) + (m != 0L ? String.valueOf(m) + "M" : EMPTY_STR) + (d != 0L ? String.valueOf(d) + "D" : EMPTY_STR) + (h + n + s != 0L ? "T" : EMPTY_STR) + (h != 0L ? String.valueOf(h) + "H" : EMPTY_STR) + (n != 0L ? String.valueOf(n) + "M" : EMPTY_STR) + (s != 0L ? String.valueOf(s) + "S" : EMPTY_STR);
    }

    private static String getFormat(String date) {
        switch (date.length()) {
            case 19: {
                return dt;
            }
            case 10: {
                return d;
            }
            case 7: {
                return gym;
            }
            case 4: {
                return gy;
            }
        }
        return EMPTY_STR;
    }
}

