/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.common.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.gov.hmrc.aspire.esps.common.io.MarkableFileInputStream;

public class InputStreamFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getInputStream(InputStream in, long memoryThreshold, File file) throws IOException {
        ByteArrayOutputStream byteOut;
        InputStream result = null;
        boolean fileStorage = false;
        OutputStream out = byteOut = new ByteArrayOutputStream((int)(memoryThreshold > 0L ? memoryThreshold : 100L));
        BufferedInputStream bis = new BufferedInputStream(in);
        try {
            int bytesRead;
            long totalByteCount = 0L;
            byte[] bytes = new byte[1024];
            while ((bytesRead = bis.read(bytes)) > -1) {
                ((OutputStream)out).write(bytes, 0, bytesRead);
                if (fileStorage || memoryThreshold <= 0L || (totalByteCount += (long)bytesRead) < memoryThreshold) continue;
                out = InputStreamFactory.getFileOutputStream(byteOut.toByteArray(), file);
                fileStorage = true;
            }
            result = fileStorage ? new MarkableFileInputStream(file) : new ByteArrayInputStream(byteOut.toByteArray());
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
        return result;
    }

    private static OutputStream getFileOutputStream(byte[] bytes, File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (file.exists()) {
            if (!file.isFile() || !file.canWrite()) {
                throw new IOException("File is invalid or is not accessible: " + file.getAbsolutePath());
            }
        } else {
            file.createNewFile();
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        BufferedOutputStream bufOut = new BufferedOutputStream(fileOut);
        bufOut.write(bytes);
        bufOut.flush();
        return fileOut;
    }
}

