/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.common.metadata;

import java.io.InputStream;
import java.util.List;
import uk.gov.hmrc.aspire.esps.common.metadata.MetaDataException;
import uk.gov.hmrc.aspire.esps.common.metadata.MetaDataParser;

public abstract class MetaData {
    private MetaDataParser parser;

    public MetaData(InputStream in) throws MetaDataException {
        List<String> currList = null;
        this.parser = new MetaDataParser(in, this.maxElementLimit());
        currList = this.valueElements();
        if (currList != null) {
            for (String elementName : currList) {
                this.parser.addValueElement(elementName);
            }
        }
        if ((currList = this.namespaceElements()) != null) {
            for (String elementName : currList) {
                this.parser.addNamespaceElement(elementName);
            }
        }
        if ((currList = this.endMarkerElements()) != null) {
            for (String elementName : currList) {
                this.parser.addEndMarkerElement(elementName);
            }
        }
        this.parser.parse();
    }

    public String getValue(String key) {
        return this.parser.getRequiredValue(key);
    }

    public static final MetaData metaDataFactory(InputStream in, int maxElements, List<String> elementValues, List<String> elementNamespaces) throws MetaDataException {
        final List<String> namespaces = elementNamespaces;
        final List<String> values = elementValues;
        final int elementLimit = maxElements;
        MetaData instance = new MetaData(in){

            @Override
            public List<String> namespaceElements() {
                return namespaces;
            }

            @Override
            public List<String> valueElements() {
                return values;
            }

            @Override
            public int maxElementLimit() {
                return elementLimit;
            }
        };
        return instance;
    }

    public List<String> endMarkerElements() {
        return null;
    }

    public List<String> getMissingElements() {
        return this.parser.getMissingRequiredFields();
    }

    public abstract List<String> namespaceElements();

    public abstract List<String> valueElements();

    public abstract int maxElementLimit();
}

