/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.common.schema;

import java.io.File;
import java.io.IOException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;
import uk.gov.hmrc.aspire.esps.common.schema.XMLSchemaInvalidException;

public class XMLSchemaValidator {
    public void validate(File xmlFile, File schemaFile) throws XMLSchemaInvalidException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = factory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            StreamSource source = new StreamSource(xmlFile);
            validator.validate(source);
        }
        catch (SAXException e1) {
            throw new XMLSchemaInvalidException("There was a problem parsing file " + xmlFile.getAbsolutePath() + ". See wrapped exceptions for details.", e1);
        }
        catch (IOException e) {
            throw new XMLSchemaInvalidException("There was a problem accessing file " + xmlFile.getAbsolutePath() + ". See wrapped exceptions for details.", e);
        }
    }
}

