/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator;

import bizrules.BusinessRuleError;
import com.gsl.docValidator.ValidationException;
import com.gsl.schematron.validator.api.SchematronValidator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import processingError.ProcessingError;
import uk.gov.hmrc.aspire.esps.common.io.InputStreamFactory;
import uk.gov.hmrc.aspire.esps.validator.SubmissionMetaData;
import uk.gov.hmrc.aspire.esps.validator.ValidationError;
import uk.gov.hmrc.aspire.esps.validator.ValidationSummary;
import uk.gov.hmrc.aspire.esps.validator.ValidatorException;
import uk.gov.hmrc.aspire.esps.validator.config.ConfigHandler;
import uk.gov.hmrc.aspire.esps.validator.config.Configuration;
import uk.gov.hmrc.aspire.esps.validator.config.ConfigurationException;
import uk.gov.hmrc.aspire.esps.validator.config.ServiceKey;
import uk.gov.hmrc.aspire.esps.validator.config.ServiceNotRegisteredException;
import uk.gov.hmrc.aspire.esps.validator.config.ValidationType;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ErrorMappingsCatalogue;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ErrorMappingsException;
import uk.gov.hmrc.aspire.esps.validator.errormappings.processor.IServiceErrorMappingProcessor;
import validationResponse.output.ValidationResult;
import xmldoc.DocumentError;

public class Validator {
    private static final long TEN_MEGABYTES = 0xA00000L;
    private static final long MAX_MEMORY_LIMIT = 0xA00000L;
    private static final String SUBMISSION_FILENAME_PREFIX = "RIMValidator_";

    public static void initialise(InputStream configFile) throws ValidatorException {
        Configuration conf = ConfigHandler.initialise(configFile);
        ErrorMappingsCatalogue.assembleMappings(conf);
    }

    public static void initialise(File configFile) throws ValidatorException {
        Configuration conf = ConfigHandler.initialise(configFile);
        ErrorMappingsCatalogue.assembleMappings(conf);
    }

    public static void initialise(Map configFile) throws ValidatorException {
        Configuration conf = ConfigHandler.initialise(configFile);
        ErrorMappingsCatalogue.assembleMappings(conf);
    }

    public ValidationSummary validate(String envelopeURI, String serviceURI, InputStream in, OutputStream out, Date date) throws ValidatorException {
        ValidationResult vr = null;
        try {
            IServiceErrorMappingProcessor serviceErrorMappingProcessor;
            ServiceKey serviceKey = new ServiceKey(envelopeURI, serviceURI);
            SchematronValidator schematronValidator = this.getSchematronValidator(serviceKey);
            if (date != null) {
                schematronValidator.setCurrentDate(date);
            }
            vr = (serviceErrorMappingProcessor = ErrorMappingsCatalogue.getInstance().getServiceErrorMappingProcessor(serviceKey)) == null ? schematronValidator.validateSubmission(in, out) : this.performValidationAndErrorMappings(schematronValidator, serviceErrorMappingProcessor, in, out);
        }
        catch (ValidationException e) {
            throw new ValidatorException("Error in GSL layer during validation: " + e.getMessage(), e);
        }
        catch (ConfigurationException e) {
            throw new ValidatorException("Configuration error: " + e.getMessage(), e);
        }
        catch (ErrorMappingsException e) {
            throw new ValidatorException("ErrorMappings error. See wrapped exception stack trace for details.", e);
        }
        catch (ValidatorException ve) {
            throw ve;
        }
        catch (Exception e) {
            throw new ValidatorException(e.getMessage(), e);
        }
        return this.copyValidationResultToValidationSummary(vr);
    }

    public ValidationSummary validate(String envelopeURI, String serviceURI, InputStream in, OutputStream out) throws ValidatorException {
        return this.validate(envelopeURI, serviceURI, in, out, null);
    }

    public ValidationSummary validate(InputStream in, OutputStream out, Date date) throws ValidatorException {
        String filename = SUBMISSION_FILENAME_PREFIX + System.currentTimeMillis() + "_" + Thread.currentThread().getId();
        SubmissionMetaData smd = null;
        try {
            in = InputStreamFactory.getInputStream(in, 0xA00000L, new File(filename));
            smd = new SubmissionMetaData(in);
            in.reset();
        }
        catch (Exception e) {
            throw new ValidatorException("Failed to extract the IRenvelope namespace from submission: " + e.getMessage(), e);
        }
        String envelopeURI = this.getEnvelopeNamespace(smd);
        String irEnvelopeURI = smd.getValue("IRenvelope");
        return this.validate(envelopeURI, irEnvelopeURI, in, out, date);
    }

    public ValidationSummary validate(InputStream in, OutputStream out) throws ValidatorException {
        return this.validate(in, out, null);
    }

    private String getEnvelopeNamespace(SubmissionMetaData smd) {
        String namespace = smd.getValue("GovTalkMessage");
        if (namespace == null) {
            namespace = smd.getValue("ChRISEnvelope");
        }
        return namespace;
    }

    private ValidationResult performValidationAndErrorMappings(SchematronValidator schematronValidator, IServiceErrorMappingProcessor serviceErrorMappingProcessor, InputStream in, OutputStream out) throws ValidationException, ErrorMappingsException {
        ValidationResult vr = null;
        ByteArrayOutputStream validatorResponse = new ByteArrayOutputStream();
        vr = schematronValidator.validateSubmission(in, (OutputStream)validatorResponse);
        ByteArrayInputStream processorInputStream = new ByteArrayInputStream(validatorResponse.toByteArray());
        serviceErrorMappingProcessor.process(processorInputStream, out);
        return vr;
    }

    public static String getVersion() {
        return Configuration.getGSLVersion();
    }

    public static void resetConfiguration() {
        Configuration.reset();
        ErrorMappingsCatalogue.reset();
    }

    private SchematronValidator getSchematronValidator(ServiceKey serviceKey) throws ValidatorException, ServiceNotRegisteredException, ConfigurationException {
        Configuration conf = Configuration.getInstance();
        if (conf == null) {
            throw new ConfigurationException("Submission for envelope: " + serviceKey.getEnvelopeURI() + " and service: " + serviceKey.getServiceURI() + " could not be processed. Configuration has not been initialised.");
        }
        SchematronValidator validator = conf.getSchematronValidator(serviceKey);
        return validator;
    }

    private ValidationSummary copyValidationResultToValidationSummary(ValidationResult validationResult) throws ValidatorException {
        ValidationSummary vs = new ValidationSummary();
        vs.setProcessingTime(validationResult.getProcessingTime());
        List list = validationResult.getProcessingErrors();
        if (list != null) {
            for (ProcessingError error : list) {
                ValidationError ve = new ValidationError();
                ve.setMessage(error.getMessage());
                ve.setXPathLocation(error.getXPathLocation());
                if (error instanceof BusinessRuleError) {
                    ve.setType(ValidationType.BUSINESS.toString());
                } else if (error instanceof DocumentError) {
                    ve.setType(ValidationType.SCHEMA.toString());
                } else {
                    throw new ValidatorException("Unknown error type: " + error.getClass().getName());
                }
                vs.setProcessingError(ve);
            }
        }
        return vs;
    }
}

