/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator;

import com.gsl.schematron.validator.api.SchematronValidatorFactories;
import com.gsl.schematron.validator.api.SchematronValidatorFactory;
import com.gsl.schematron.validator.api.SchematronValidatorParams;
import uk.gov.hmrc.aspire.esps.validator.EngineType;
import uk.gov.hmrc.aspire.esps.validator.config.ConfigurationException;
import uk.gov.hmrc.aspire.esps.validator.config.GlobalConfiguration;
import uk.gov.hmrc.aspire.esps.validator.config.ServiceConfiguration;
import uk.gov.hmrc.aspire.esps.validator.config.ValidationType;
import uk.gov.hmrc.aspire.esps.validator.config.ValidatorType;

public class ValidatorFactory {
    public static SchematronValidatorFactory getSchematronValidatorFactory(String uri, GlobalConfiguration gconf, ServiceConfiguration sconf) throws ConfigurationException {
        if (gconf.getRIMValidator().equals(EngineType.GSL.toString())) {
            return ValidatorFactory.gslFactory(uri, gconf, sconf);
        }
        return ValidatorFactory.gslFactory(uri, gconf, sconf);
    }

    private static SchematronValidatorFactory gslFactory(String uri, GlobalConfiguration gconf, ServiceConfiguration sconf) throws ConfigurationException {
        SchematronValidatorFactory factory = null;
        try {
            ValidatorType validatorType = gconf.getValidatorType();
            switch (validatorType) {
                case PRECOMPILED: {
                    factory = SchematronValidatorFactories.createClasspathLoadingValidatorFactory((SchematronValidatorParams)ValidatorFactory.buildGSLParams(gconf, sconf));
                    break;
                }
                case STATIC: {
                    factory = SchematronValidatorFactories.createStaticCompilingValidatorFactory((SchematronValidatorParams)ValidatorFactory.buildGSLParams(gconf, sconf));
                    break;
                }
                case DYNAMIC: {
                    factory = SchematronValidatorFactories.createDynamicCompilingValidatorFactory((SchematronValidatorParams)ValidatorFactory.buildGSLParams(gconf, sconf));
                }
            }
            if (factory == null) {
                throw new ConfigurationException("Invalid ValidatorType was specified in the validator configuration file. Please refer to EPIDD document.");
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to create GSL Validator Factory for service " + uri + ". A likely cause is that the GSL config files are not on the class path.", e);
        }
        return factory;
    }

    private static SchematronValidatorParams buildGSLParams(GlobalConfiguration gconf, ServiceConfiguration sconf) {
        SchematronValidatorParams params = new SchematronValidatorParams();
        params.setTemporaryDirpath(gconf.getTempDirectory());
        params.setRIMArtefactsDirectory(sconf.getRimArtefactsDirectory());
        params.setLoggingLevel(gconf.getLoggingLevel());
        params.setValidationType(ValidatorFactory.getGSLValidationType(sconf.getValidationType()));
        params.setMaxErrors(sconf.getTotalErrorCap());
        return params;
    }

    private static com.gsl.schematron.validator.api.ValidationType getGSLValidationType(ValidationType validationType) {
        switch (validationType) {
            case COMPLETE: {
                return com.gsl.schematron.validator.api.ValidationType.COMPLETE;
            }
            case BUSINESS: {
                return com.gsl.schematron.validator.api.ValidationType.BUSINESS_ONLY;
            }
            case SCHEMA: {
                return com.gsl.schematron.validator.api.ValidationType.SCHEMA_ONLY;
            }
        }
        return com.gsl.schematron.validator.api.ValidationType.COMPLETE;
    }
}

