/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.config;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import uk.gov.hmrc.aspire.esps.validator.ValidatorException;
import uk.gov.hmrc.aspire.esps.validator.config.Configuration;

public class ConfigHandler {
    public static Configuration initialise(InputStream configFile) throws ValidatorException {
        Configuration conf;
        try {
            conf = Configuration.assembleConfiguration(configFile);
        }
        catch (Exception e) {
            throw new ValidatorException("Failed to initialise configuration.", e);
        }
        return conf;
    }

    public static Configuration initialise(File configFile) throws ValidatorException {
        ConfigHandler.validateConfigurationFile(configFile);
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(configFile));
        }
        catch (FileNotFoundException e) {
            throw new ValidatorException("Could not create input stream to file: " + configFile.getAbsolutePath(), e);
        }
        return ConfigHandler.initialise(in);
    }

    public static Configuration initialise(Map params) throws ValidatorException {
        Object obj = params.get("configFile");
        if (obj == null) {
            throw new ValidatorException("Did not find configuration file key 'configFile' in parameters map", null);
        }
        File configFile = null;
        if (!(obj instanceof File)) {
            throw new ValidatorException("Configuration file key 'configFile' in parameters map does not refer to a valid File object.", null);
        }
        configFile = (File)obj;
        return ConfigHandler.initialise(configFile);
    }

    private static void validateConfigurationFile(File configFile) throws ValidatorException {
        if (!configFile.isFile()) {
            throw new ValidatorException("File object does not refer to a valid file: " + configFile.getAbsolutePath(), null);
        }
        if (!configFile.getName().endsWith("xml") && !configFile.getName().endsWith("XML")) {
            throw new ValidatorException("File object does not refer to a valid xml file: " + configFile.getAbsolutePath(), null);
        }
    }
}

