/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.config;

import com.gsl.schematron.validator.api.SchematronValidator;
import com.gsl.schematron.validator.api.SchematronValidatorFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import uk.gov.hmrc.aspire.esps.validator.ValidatorFactory;
import uk.gov.hmrc.aspire.esps.validator.config.ConfigurationException;
import uk.gov.hmrc.aspire.esps.validator.config.Constants;
import uk.gov.hmrc.aspire.esps.validator.config.GlobalConfiguration;
import uk.gov.hmrc.aspire.esps.validator.config.ServiceConfiguration;
import uk.gov.hmrc.aspire.esps.validator.config.ServiceKey;
import uk.gov.hmrc.aspire.esps.validator.config.ServiceNotRegisteredException;
import uk.gov.hmrc.aspire.esps.validator.config.ValidationType;
import uk.gov.hmrc.aspire.esps.validator.config.ValidatorType;

public class Configuration {
    private static Configuration uniqueInstance;
    private static boolean firstTime;
    private GlobalConfiguration globalConfig;
    private Map<ServiceKey, ServiceConfiguration> serviceConfigMap = new HashMap<ServiceKey, ServiceConfiguration>();
    private Map<ServiceKey, SchematronValidatorFactory> factories = new HashMap<ServiceKey, SchematronValidatorFactory>();

    private Configuration() {
    }

    public static synchronized Configuration getInstance(InputStream configFile) throws ConfigurationException {
        if (uniqueInstance == null) {
            uniqueInstance = Configuration.loadConfigXml(configFile);
            Configuration.loadSchematronFactories(uniqueInstance);
            Configuration.setFirstTime(false);
        }
        return uniqueInstance;
    }

    private static void loadSchematronFactories(Configuration conf) throws ConfigurationException {
        for (ServiceKey serviceKey : conf.serviceConfigMap.keySet()) {
            ServiceConfiguration sconf = conf.serviceConfigMap.get(serviceKey);
            conf.factories.put(serviceKey, ValidatorFactory.getSchematronValidatorFactory(serviceKey.getKeyAsString(), conf.globalConfig, sconf));
        }
        Iterator<ServiceKey> iterator = conf.factories.keySet().iterator();
        boolean isFirstTime = true;
        StringBuffer sb = new StringBuffer();
        sb.append("\n*********************************************************************");
        while (iterator.hasNext()) {
            ServiceKey uri = iterator.next();
            if (isFirstTime) {
                sb.append("\nSchematron Validator - version: ");
                sb.append(conf.factories.get(uri).getVersionNumber());
                isFirstTime = false;
            }
            sb.append("\nService = ");
            sb.append(uri);
        }
        sb.append("\n*********************************************************************\n");
        System.out.println(sb.toString());
    }

    public static Configuration getInstance() {
        return uniqueInstance;
    }

    public static Configuration assembleConfiguration(InputStream configFile) throws ConfigurationException {
        if (Configuration.isFirstTime()) {
            return Configuration.getInstance(configFile);
        }
        return Configuration.getInstance();
    }

    public static boolean isFirstTime() {
        return firstTime;
    }

    public static void setFirstTime(boolean ft) {
        firstTime = ft;
    }

    private static Configuration loadConfigXml(InputStream configFile) throws ConfigurationException {
        Configuration conf = new Configuration();
        GlobalConfiguration gconf = new GlobalConfiguration();
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(configFile);
        }
        catch (JDOMException e) {
            throw new ConfigurationException("Configuration cannot get a Parser to parse the config file.", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Configuration could not parse input config file", e);
        }
        Element root = doc.getRootElement();
        Element currElement2 = root.getChild("RIMValidator");
        if (currElement2 != null) {
            gconf.setRIMValidator(currElement2.getTextTrim());
        } else {
            gconf.setRIMValidator("GSL");
        }
        currElement2 = root.getChild("TempDirectory");
        if (currElement2 == null || currElement2.getTextTrim().length() <= 0) {
            throw new ConfigurationException("Mandatory element 'TempDirectory' is missing or empty.");
        }
        gconf.setTempDirectory(Configuration.validateTempDirectory(currElement2.getTextTrim()));
        currElement2 = root.getChild("LoggingLevel");
        if (currElement2 != null) {
            Configuration.setLoggingLevel(gconf, currElement2.getTextTrim());
        } else {
            gconf.setLoggingLevel(Constants.DEFAULT_LOGGING_LEVEL);
        }
        currElement2 = root.getChild("ValidatorType");
        if (currElement2 == null || currElement2.getTextTrim().length() <= 0) {
            throw new ConfigurationException("Mandatory element 'ValidatorType' is missing or empty.");
        }
        Configuration.setValidatorType(gconf, currElement2.getTextTrim());
        List list = root.getChildren("InternalSchema");
        for (Element currElement2 : list) {
            String uri = null;
            String filename = null;
            if (currElement2 == null || currElement2.getAttributeValue("uri").length() <= 0) {
                throw new ConfigurationException("Mandatory attribute 'uri' of element 'InternalSchema' is missing or empty.");
            }
            uri = currElement2.getAttributeValue("uri");
            if (currElement2 == null || currElement2.getTextTrim().length() <= 0) {
                throw new ConfigurationException("Mandatory element 'InternalSchema' is missing or empty.");
            }
            filename = currElement2.getTextTrim();
            gconf.setInternalSchema(uri, Configuration.validateInternalSchema(filename));
        }
        conf.globalConfig = gconf;
        List envelopeList = root.getChildren("Envelope");
        if (envelopeList.size() == 0) {
            throw new ConfigurationException("There are no Envelopes registered in configuration file.");
        }
        for (int j = 0; j < envelopeList.size(); ++j) {
            Element envelopeElement = (Element)envelopeList.get(j);
            Attribute envelopeAttr = envelopeElement.getAttribute("uri");
            String envelopeURI = null;
            if (envelopeAttr == null) {
                throw new ConfigurationException("Envelope URI attribute is missing in configuration file.");
            }
            envelopeURI = envelopeAttr.getValue();
            List serviceElements = envelopeElement.getChildren("Service");
            if (serviceElements.size() == 0) {
                throw new ConfigurationException("There are no Services registered for Envelope " + envelopeURI + " in config");
            }
            for (int i = 0; i < serviceElements.size(); ++i) {
                Element serviceNode = (Element)serviceElements.get(i);
                Attribute currAttribute = serviceNode.getAttribute("uri");
                if (currAttribute == null) {
                    throw new ConfigurationException("Service URI attribute is missing in configuration file.");
                }
                String serviceURI = currAttribute.getValue();
                ServiceKey serviceConfigKey = new ServiceKey(envelopeURI, serviceURI);
                if (conf.serviceConfigMap.containsKey(serviceConfigKey)) {
                    throw new ConfigurationException("Duplicate service entries in configuration file for: " + serviceConfigKey);
                }
                ServiceConfiguration sconf = new ServiceConfiguration(serviceConfigKey);
                currElement2 = serviceNode.getChild("RIMArtefactsDirectory");
                if (currElement2 == null || currElement2.getTextTrim().length() <= 0) {
                    throw new ConfigurationException("Mandatory element 'RIMArtefactsDirectory' is missing.");
                }
                sconf.setRimArtefactsDirectory(Configuration.validateArtefactsDirectory(currElement2.getTextTrim()));
                currElement2 = serviceNode.getChild("TotalErrorCap");
                if (currElement2 != null) {
                    sconf.setTotalErrorCap(Integer.parseInt(currElement2.getTextTrim()));
                } else {
                    sconf.setTotalErrorCap(100);
                }
                currElement2 = serviceNode.getChild("ValidationType");
                if (currElement2 != null) {
                    Configuration.setValidationType(sconf, currElement2.getTextTrim());
                } else {
                    sconf.setValidationType(Constants.DEFAULT_VALIDATION_TYPE);
                }
                Configuration.loadErrorMappingConfig(sconf, serviceNode);
                conf.serviceConfigMap.put(sconf.getKey(), sconf);
            }
        }
        return conf;
    }

    private static void loadErrorMappingConfig(ServiceConfiguration serviceConfig, Element serviceNode) throws ConfigurationException {
        Element errorMappingElement = serviceNode.getChild("ErrorMapping");
        if (errorMappingElement != null) {
            String errorMappingSchemaLocation;
            Element tempElement = errorMappingElement.getChild("Schema");
            if (tempElement != null) {
                Attribute attribute = tempElement.getAttribute("uri");
                if (attribute == null) {
                    throw new ConfigurationException("ErrorMapping defined for Service[" + serviceConfig.getKey() + "] but no URI found!");
                }
                serviceConfig.setErrorMappingSchemaURI(attribute.getValue());
                errorMappingSchemaLocation = tempElement.getTextTrim();
                if (errorMappingSchemaLocation == null || errorMappingSchemaLocation.length() <= 0) {
                    throw new ConfigurationException("ErrorMapping defined for Service[" + serviceConfig.getKey() + "] but no schema location found!");
                }
            } else {
                throw new ConfigurationException("ErrorMapping defined for Service[" + serviceConfig.getKey() + "] but no Schema element found!");
            }
            serviceConfig.setErrorMappingSchemaLocation(errorMappingSchemaLocation);
            tempElement = errorMappingElement.getChild("MappingProcessor");
            if (tempElement != null) {
                String errorMappingProcessor = tempElement.getTextTrim();
                if (errorMappingProcessor != null && errorMappingProcessor.length() > 0) {
                    serviceConfig.setErrorMappingProcessor(errorMappingProcessor);
                }
            } else {
                throw new ConfigurationException("ErrorMapping defined for Service[" + serviceConfig.getKey() + "] but no MappingProcessor element found!");
            }
            tempElement = errorMappingElement.getChild("MappingFile");
            if (tempElement != null) {
                String errorMappingFile = tempElement.getTextTrim();
                if (errorMappingFile != null && errorMappingFile.length() > 0) {
                    serviceConfig.setErrorMappingFileName(errorMappingFile);
                }
            } else {
                throw new ConfigurationException("ErrorMapping defined for Service[" + serviceConfig.getKey() + "] but no MappingFile element found!");
            }
            File rimDir = new File(serviceConfig.getRimArtefactsDirectory());
            File errorMappingFile = new File(rimDir, serviceConfig.getErrorMappingFileName());
            if (!errorMappingFile.exists()) {
                throw new ConfigurationException("ErrorMapping File [" + errorMappingFile.getAbsolutePath() + "] defined for Service[" + serviceConfig.getKey() + "] could not be found!");
            }
            serviceConfig.setErrorMappingPresent(true);
        }
    }

    private static String validateTempDirectory(String dir) throws ConfigurationException {
        File tempDir = new File(dir);
        String hmrcToolsRoot = System.getProperty("hmrctools.root");
        if (hmrcToolsRoot != null && hmrcToolsRoot.trim().length() > 0 && !tempDir.isAbsolute()) {
            tempDir = new File(hmrcToolsRoot, dir);
        }
        if (tempDir.exists() && !tempDir.isDirectory()) {
            throw new ConfigurationException("TempDirectory '" + dir + "' does not point to a valid directory");
        }
        return tempDir.getAbsolutePath();
    }

    private static String validateArtefactsDirectory(String dir) throws ConfigurationException {
        File artefactDir = new File(dir);
        String hmrcToolsRoot = System.getProperty("hmrctools.root");
        if (hmrcToolsRoot != null && hmrcToolsRoot.trim().length() > 0 && !artefactDir.isAbsolute()) {
            artefactDir = new File(new File(hmrcToolsRoot, "RIMArtefacts"), dir);
        }
        if (!artefactDir.exists() || !artefactDir.isDirectory()) {
            throw new ConfigurationException("RIMArtefactsDirectory '" + artefactDir.getPath() + "' does not point to a valid directory");
        }
        File[] artefactFiles = artefactDir.listFiles();
        if (artefactFiles == null || artefactFiles.length == 0) {
            throw new ConfigurationException("RIMArtefactsDirectory '" + artefactDir.getPath() + "' points to an empty directory");
        }
        int count = 0;
        for (int i = 0; i < artefactFiles.length; ++i) {
            File file = artefactFiles[i];
            if (!file.isFile() || !file.getName().endsWith("xsd") && !file.getName().endsWith("XSD") && !file.getName().endsWith("sch") && !file.getName().endsWith("SCH")) continue;
            ++count;
        }
        if (count == 0) {
            throw new ConfigurationException("RIMArtefactsDirectory '" + artefactDir.getPath() + "' points to a directory which does not contain any schema (.xsd) or business (.sch) rules.");
        }
        return artefactDir.getAbsolutePath();
    }

    private static void setValidationType(ServiceConfiguration sconf, String validationType) {
        ValidationType vt = null;
        vt = validationType.equals("COMPLETE") ? ValidationType.COMPLETE : (validationType.equals("SCHEMA") ? ValidationType.SCHEMA : (validationType.equals("BUSINESS") ? ValidationType.BUSINESS : ValidationType.COMPLETE));
        sconf.setValidationType(vt);
    }

    private static void setValidatorType(GlobalConfiguration gconf, String validatorType) throws ConfigurationException {
        ValidatorType vt = null;
        if (validatorType.equals("PRECOMPILED")) {
            vt = ValidatorType.PRECOMPILED;
        } else if (validatorType.equals("STATIC")) {
            vt = ValidatorType.STATIC;
        } else if (validatorType.equals("DYNAMIC")) {
            vt = ValidatorType.DYNAMIC;
        } else {
            throw new ConfigurationException("Mandatory element 'ValidatorType' has unexpected value '" + validatorType + "'.");
        }
        gconf.setValidatorType(vt);
    }

    private static void setLoggingLevel(GlobalConfiguration gconf, String loggingLevel) {
        Level level = null;
        level = loggingLevel.equals(Level.SEVERE.toString()) ? Level.SEVERE : (loggingLevel.equals(Level.WARNING.toString()) ? Level.WARNING : (loggingLevel.equals(Level.INFO.toString()) ? Level.INFO : Level.OFF));
        gconf.setLoggingLevel(level);
    }

    public Map<ServiceKey, ServiceConfiguration> getServiceConfigurationMap() {
        return this.serviceConfigMap;
    }

    public static ValidationType getValidationType(String uri) {
        ServiceConfiguration config = Configuration.uniqueInstance.serviceConfigMap.get(uri);
        return config != null ? config.getValidationType() : null;
    }

    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfig;
    }

    public static String getGSLVersion() {
        String version;
        block1: {
            version = null;
            if (uniqueInstance == null) {
                return null;
            }
            Iterator<ServiceKey> iterator = Configuration.uniqueInstance.factories.keySet().iterator();
            if (!iterator.hasNext()) break block1;
            String uri = (String)((Object)iterator.next());
            version = Configuration.uniqueInstance.factories.get(uri).getVersionNumber();
        }
        return version;
    }

    public SchematronValidator getSchematronValidator(ServiceKey serviceKey) throws ServiceNotRegisteredException, ConfigurationException {
        if (uniqueInstance == null) {
            throw new ConfigurationException("Submission for envelope:" + serviceKey.getEnvelopeURI() + " and service: " + serviceKey.getServiceURI() + " could not be processed. Configuration has not been initialised.");
        }
        SchematronValidatorFactory svf = Configuration.uniqueInstance.factories.get(serviceKey);
        if (svf == null) {
            throw new ServiceNotRegisteredException(serviceKey.getKeyAsString());
        }
        return svf.createValidator();
    }

    public static void reset() {
        Configuration conf = Configuration.getInstance();
        if (conf != null) {
            conf.factories = null;
            conf.globalConfig = null;
            conf.serviceConfigMap = null;
            uniqueInstance = null;
            Configuration.setFirstTime(true);
            System.gc();
        }
    }

    private static String validateInternalSchema(String filename) throws ConfigurationException {
        File file = new File(filename);
        String ltsRoot = System.getProperty("lts.root");
        if (ltsRoot != null && ltsRoot.trim().length() > 0 && !file.isAbsolute()) {
            file = new File(ltsRoot, filename);
        }
        if (!file.isFile() || !file.exists()) {
            throw new ConfigurationException("InternalSchema '" + file.getAbsolutePath() + "' does not point to a valid file");
        }
        return file.getAbsolutePath();
    }

    static {
        firstTime = true;
    }
}

