/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.errormappings;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import uk.gov.hmrc.aspire.esps.validator.config.Configuration;
import uk.gov.hmrc.aspire.esps.validator.config.GlobalConfiguration;
import uk.gov.hmrc.aspire.esps.validator.config.ServiceConfiguration;
import uk.gov.hmrc.aspire.esps.validator.config.ServiceKey;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ErrorMappingsException;
import uk.gov.hmrc.aspire.esps.validator.errormappings.processor.IServiceErrorMappingProcessor;
import uk.gov.hmrc.aspire.esps.validator.errormappings.processor.ServiceErrorMappingProcessorFactory;

public class ErrorMappingsCatalogue {
    private static ErrorMappingsCatalogue uniqueInstance;
    private static boolean firstTime;
    private Map<ServiceKey, IServiceErrorMappingProcessor> errorMappingProcessors = new HashMap<ServiceKey, IServiceErrorMappingProcessor>();

    private ErrorMappingsCatalogue() {
    }

    private static synchronized ErrorMappingsCatalogue getInstance(Configuration config) throws ErrorMappingsException {
        if (uniqueInstance == null) {
            uniqueInstance = ErrorMappingsCatalogue.loadServiceMappings(config);
            ErrorMappingsCatalogue.setFirstTime(false);
            ErrorMappingsCatalogue.displayErrorMappingsInfo();
        }
        return uniqueInstance;
    }

    public static ErrorMappingsCatalogue getInstance() {
        return uniqueInstance;
    }

    public static ErrorMappingsCatalogue assembleMappings(Configuration config) throws ErrorMappingsException {
        if (ErrorMappingsCatalogue.isFirstTime()) {
            return ErrorMappingsCatalogue.getInstance(config);
        }
        return ErrorMappingsCatalogue.getInstance();
    }

    private static boolean isFirstTime() {
        return firstTime;
    }

    private static void setFirstTime(boolean ft) {
        firstTime = ft;
    }

    private static ErrorMappingsCatalogue loadServiceMappings(Configuration config) throws ErrorMappingsException {
        ErrorMappingsCatalogue catalogue = new ErrorMappingsCatalogue();
        Map<ServiceKey, ServiceConfiguration> serviceConfigMap = config.getServiceConfigurationMap();
        GlobalConfiguration gconf = config.getGlobalConfiguration();
        ServiceErrorMappingProcessorFactory serviceErrorMappingProcFactory = new ServiceErrorMappingProcessorFactory(gconf);
        Collection<ServiceConfiguration> serviceConfigCollection = serviceConfigMap.values();
        for (ServiceConfiguration serviceConfig : serviceConfigCollection) {
            IServiceErrorMappingProcessor processor = serviceErrorMappingProcFactory.createServiceErrorMappingProcessor(serviceConfig);
            if (processor == null) continue;
            catalogue.errorMappingProcessors.put(serviceConfig.getKey(), processor);
        }
        return catalogue;
    }

    public Map<ServiceKey, IServiceErrorMappingProcessor> getServiceErrorMappingProcessors() {
        return this.errorMappingProcessors;
    }

    public IServiceErrorMappingProcessor getServiceErrorMappingProcessor(ServiceKey serviceKey) {
        return this.errorMappingProcessors.get(serviceKey);
    }

    public static void reset() {
        ErrorMappingsCatalogue emc = ErrorMappingsCatalogue.getInstance();
        if (emc != null) {
            emc.errorMappingProcessors = null;
            uniqueInstance = null;
            ErrorMappingsCatalogue.setFirstTime(true);
            System.gc();
        }
    }

    public static void displayErrorMappingsInfo() {
        Map<ServiceKey, IServiceErrorMappingProcessor> errorMappings = ErrorMappingsCatalogue.getInstance().getServiceErrorMappingProcessors();
        StringBuffer sb = new StringBuffer();
        boolean isFirstTime = true;
        if (!errorMappings.isEmpty()) {
            for (ServiceKey key : errorMappings.keySet()) {
                IServiceErrorMappingProcessor sm = errorMappings.get(key);
                if (sm == null) continue;
                if (isFirstTime) {
                    sb.append("*********************************************************************");
                    isFirstTime = false;
                }
                sb.append("\n");
                sb.append("Error Mappings loaded for: " + key);
            }
            if (!isFirstTime) {
                sb.append("\n");
                sb.append("*********************************************************************");
                sb.append("\n");
            }
            System.out.println(sb.toString());
        }
    }

    static {
        firstTime = true;
    }
}

