/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.errormappings;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ErrorMappingsException;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ServiceMapping;

public class ServiceErrorMapper {
    public void mapServiceErrors(ServiceMapping serviceMapping, InputStream validatorResultStream, OutputStream out) throws ErrorMappingsException {
        Document doc = this.getValidatorResponseAsDocument(validatorResultStream);
        Element root = doc.getRootElement();
        Namespace valNamespace = root.getNamespace();
        List list = root.getChildren();
        boolean errorResponseFound = false;
        Iterator it = list.iterator();
        Element errorResponseElement = null;
        while (it.hasNext()) {
            errorResponseElement = (Element)it.next();
            if (!errorResponseElement.getName().equals("ErrorResponse")) continue;
            errorResponseFound = true;
            break;
        }
        if (!errorResponseFound) {
            this.writeResponseToOutputStream(doc, out);
            return;
        }
        Namespace errNamespace = errorResponseElement.getNamespace();
        list = errorResponseElement.getChildren("Error", errNamespace);
        it = list.iterator();
        Element errorElement = null;
        while (it.hasNext()) {
            errorElement = (Element)it.next();
            this.appendServiceSpecificError(serviceMapping, valNamespace, errNamespace, errorElement);
        }
        this.writeResponseToOutputStream(doc, out);
    }

    private void appendServiceSpecificError(ServiceMapping serviceMapping, Namespace valNamespace, Namespace errNamespace, Element errorElement) {
        String xpath = errorElement.getChild("Location", errNamespace).getTextTrim();
        String numberId = errorElement.getChild("Number", errNamespace).getTextTrim();
        if ((xpath = xpath.replaceAll("\\[[0-9]*\\]", "")) == null || xpath.length() == 0 || numberId == null || numberId.length() == 0) {
            return;
        }
        String userCode = null;
        String userText = null;
        String location = null;
        if (serviceMapping.getError(xpath) != null && serviceMapping.getError(xpath).getErrorNumber(numberId) != null) {
            userCode = serviceMapping.getUserCode(xpath, numberId);
            userText = serviceMapping.getUserText(xpath, numberId);
            location = serviceMapping.getLocation(xpath);
        } else if (serviceMapping.getGlobalError(numberId) != null) {
            userCode = serviceMapping.getGlobalUserCode(numberId);
            userText = serviceMapping.getGlobalUserText(numberId);
            location = null;
        } else {
            return;
        }
        this.buildAndAppendError(valNamespace, errNamespace, errorElement, userCode, userText, location);
    }

    private void buildAndAppendError(Namespace valNamespace, Namespace errNamespace, Element errorElement, String userCode, String userText, String location) {
        Element serviceMsgElement;
        Element msgElement;
        Element appElement = errorElement.getChild("Application", errNamespace);
        if (appElement == null) {
            appElement = new Element("Application", errNamespace);
            errorElement.addContent((Content)appElement);
        }
        if ((msgElement = appElement.getChild("Messages", valNamespace)) == null) {
            msgElement = new Element("Messages", valNamespace);
            appElement.addContent((Content)msgElement);
        }
        if ((serviceMsgElement = msgElement.getChild("ServiceMessage", valNamespace)) == null) {
            serviceMsgElement = new Element("ServiceMessage", valNamespace);
            msgElement.addContent((Content)serviceMsgElement);
        }
        if (location != null) {
            Element locElement = new Element("UserLocation", valNamespace);
            locElement.setText(location);
            serviceMsgElement.addContent((Content)locElement);
        }
        Element txtElement = new Element("UserText", valNamespace);
        Attribute numAttribute = new Attribute("number", userCode);
        txtElement.setAttribute(numAttribute);
        txtElement.setText(userText);
        serviceMsgElement.addContent((Content)txtElement);
    }

    private Document getValidatorResponseAsDocument(InputStream in) throws ErrorMappingsException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(in);
        }
        catch (JDOMException e) {
            throw new ErrorMappingsException("There was a problem parsing validator response. See wrapped exception for details.", e);
        }
        catch (IOException e) {
            throw new ErrorMappingsException("There was a problem accessing the validator response that was written to memory. See wrapped exception for details.", e);
        }
        return doc;
    }

    private void writeResponseToOutputStream(Document doc, OutputStream out) throws ErrorMappingsException {
        Format format = Format.getPrettyFormat();
        XMLOutputter serializer = new XMLOutputter(format);
        try {
            serializer.output(doc, out);
        }
        catch (IOException e) {
            throw new ErrorMappingsException("There was a problem trying to write contents of JDOM Document to the output stream following errors match. See wrapped exception for details.", e);
        }
    }
}

