/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.errormappings;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import uk.gov.hmrc.aspire.esps.validator.errormappings.Error;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ErrorNumber;

public class ServiceMapping {
    private String form;
    private SortedMap<String, Error> errors = new TreeMap<String, Error>();
    private SortedMap<String, ErrorNumber> globalErrors = new TreeMap<String, ErrorNumber>();

    public String getForm() {
        return this.form;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public Error getError(String xpath) {
        return (Error)this.errors.get(xpath);
    }

    public void setError(String xpath, Error error) {
        this.errors.put(xpath, error);
    }

    public String getLocation(String xpath) {
        Error error = this.getError(xpath);
        return error == null ? null : error.getLocation();
    }

    public String getUserCode(String xpath, String numberID) {
        Error error = this.getError(xpath);
        if (error == null) {
            return null;
        }
        ErrorNumber en = error.getErrorNumber(numberID);
        return en == null ? null : en.getUserCode();
    }

    public String getUserText(String xpath, String numberID) {
        Error error = this.getError(xpath);
        if (error == null) {
            return null;
        }
        ErrorNumber en = error.getErrorNumber(numberID);
        return en == null ? null : en.getUserText();
    }

    public Map<String, Error> getErrors() {
        return this.errors;
    }

    public ErrorNumber getGlobalError(String id) {
        return (ErrorNumber)this.globalErrors.get(id);
    }

    public void setGlobalError(String id, ErrorNumber globalError) {
        this.globalErrors.put(id, globalError);
    }

    public String getGlobalUserCode(String id) {
        ErrorNumber globalError = this.getGlobalError(id);
        if (globalError == null) {
            return null;
        }
        return globalError.getUserCode();
    }

    public String getGlobalUserText(String id) {
        ErrorNumber globalError = this.getGlobalError(id);
        if (globalError == null) {
            return null;
        }
        return globalError.getUserText();
    }

    public Map<String, ErrorNumber> getGlobalErrors() {
        return this.globalErrors;
    }
}

