/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.errormappings.processor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import uk.gov.hmrc.aspire.esps.validator.config.ServiceConfiguration;
import uk.gov.hmrc.aspire.esps.validator.errormappings.Error;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ErrorMappingsException;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ErrorNumber;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ServiceErrorMapper;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ServiceMapping;
import uk.gov.hmrc.aspire.esps.validator.errormappings.processor.ServiceErrorMappingProcessor;

public class DefaultServiceErrorMappingProcessor
extends ServiceErrorMappingProcessor {
    private File serviceErrorMappingsFile;
    private ServiceMapping serviceMapping;

    public DefaultServiceErrorMappingProcessor(ServiceConfiguration serviceConfiguration, File serviceErrorMappingsFile) throws ErrorMappingsException {
        super(serviceConfiguration);
        this.serviceErrorMappingsFile = serviceErrorMappingsFile;
        this.initialise();
    }

    private void initialise() throws ErrorMappingsException {
        String serviceURI = this.getServiceConfiguration().getServiceURI();
        Document doc = this.buildDOM(this.serviceErrorMappingsFile);
        this.serviceMapping = new ServiceMapping();
        Element root = doc.getRootElement();
        String mappingURI = null;
        Attribute currAttribute = root.getAttribute("form");
        if (currAttribute == null) {
            throw new ErrorMappingsException("Mandatory attribute 'form' is missing");
        }
        mappingURI = currAttribute.getValue();
        if (!serviceURI.equals(mappingURI)) {
            System.out.println("WARNING - The 'form' uri " + mappingURI + " inside file " + this.serviceErrorMappingsFile.getAbsolutePath() + " did not match the expected uri " + serviceURI + " registered in the validator config for this service.");
        }
        this.serviceMapping.setForm(mappingURI);
        this.loadGlobalErrorMappings(root, this.serviceMapping);
        this.loadServiceErrorMappings(root, this.serviceMapping);
    }

    private void loadGlobalErrorMappings(Element root, ServiceMapping smapping) throws ErrorMappingsException {
        Element gErrorsElement = root.getChild("GlobalErrors", root.getNamespace());
        if (gErrorsElement != null) {
            List gErrorChildren = gErrorsElement.getChildren("GlobalError", root.getNamespace());
            if (gErrorChildren == null) {
                throw new ErrorMappingsException("Mandatory element GlobalError is missing");
            }
            Element currElement = null;
            Attribute currAttribute = null;
            Iterator gErrorIterator = gErrorChildren.iterator();
            while (gErrorIterator.hasNext()) {
                ErrorNumber globalError = new ErrorNumber();
                Element gErrorChild = (Element)gErrorIterator.next();
                currAttribute = gErrorChild.getAttribute("id");
                if (currAttribute == null || currAttribute.getValue().length() <= 0) {
                    throw new ErrorMappingsException("Mandatory attribute 'id' is missing or empty");
                }
                globalError.setId(currAttribute.getValue());
                currElement = gErrorChild.getChild("UserCode", root.getNamespace());
                if (currElement == null || currElement.getTextTrim().length() <= 0) {
                    throw new ErrorMappingsException("Mandatory element 'UserCode' is missing or empty");
                }
                globalError.setUserCode(currElement.getTextTrim());
                currElement = gErrorChild.getChild("UserText", root.getNamespace());
                if (currElement == null) {
                    throw new ErrorMappingsException("Mandatory element 'UserText' is missing");
                }
                globalError.setUserText(currElement.getTextTrim());
                smapping.setGlobalError(globalError.getId(), globalError);
            }
        }
    }

    private void loadServiceErrorMappings(Element root, ServiceMapping smapping) throws ErrorMappingsException {
        List errorElements = root.getChildren("Error", root.getNamespace());
        if (errorElements != null) {
            Iterator errorIterator = errorElements.iterator();
            while (errorIterator.hasNext()) {
                Error error = new Error();
                Element errorElement = (Element)errorIterator.next();
                Attribute currAttribute = errorElement.getAttribute("xpath");
                if (currAttribute == null) {
                    throw new ErrorMappingsException("Mandatory attribute 'xpath' is missing");
                }
                error.setXpath(currAttribute.getValue());
                Element currElement = errorElement.getChild("Location", root.getNamespace());
                if (currElement != null) {
                    error.setLocation(currElement.getTextTrim());
                } else {
                    error.setLocation(null);
                }
                Element errorNumbers = errorElement.getChild("ErrorNumbers", root.getNamespace());
                if (errorNumbers == null) {
                    throw new ErrorMappingsException("Mandatory element ErrorNumbers is missing");
                }
                List numberChildren = errorNumbers.getChildren("Number", root.getNamespace());
                if (numberChildren == null) {
                    throw new ErrorMappingsException("Mandatory element Number is missing");
                }
                Iterator numberIterator = numberChildren.iterator();
                while (numberIterator.hasNext()) {
                    ErrorNumber errorNumber = new ErrorNumber();
                    Element numberChild = (Element)numberIterator.next();
                    currAttribute = numberChild.getAttribute("id");
                    if (currAttribute == null || currAttribute.getValue().length() <= 0) {
                        throw new ErrorMappingsException("Mandatory attribute 'id' is missing or empty");
                    }
                    errorNumber.setId(currAttribute.getValue());
                    currElement = numberChild.getChild("UserCode", root.getNamespace());
                    if (currElement == null || currElement.getTextTrim().length() <= 0) {
                        throw new ErrorMappingsException("Mandatory element 'UserCode' is missing or empty");
                    }
                    errorNumber.setUserCode(currElement.getTextTrim());
                    currElement = numberChild.getChild("UserText", root.getNamespace());
                    if (currElement == null) {
                        throw new ErrorMappingsException("Mandatory element 'UserText' is missing");
                    }
                    errorNumber.setUserText(currElement.getTextTrim());
                    error.setErrorNumber(errorNumber.getId(), errorNumber);
                }
                this.serviceMapping.setError(error.getXpath(), error);
            }
        }
    }

    private Document buildDOM(File serviceErrorMappingsFile) throws ErrorMappingsException {
        Document doc = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(serviceErrorMappingsFile);
        }
        catch (JDOMException e) {
            throw new ErrorMappingsException("There was a problem parsing file " + serviceErrorMappingsFile.getAbsolutePath() + ". See wrapped exceptions for details.", e);
        }
        catch (IOException e) {
            throw new ErrorMappingsException("There was a problem accessing file " + serviceErrorMappingsFile.getAbsolutePath() + ". See wrapped exceptions for details.", e);
        }
        return doc;
    }

    @Override
    public void process(InputStream validatorResultStream, OutputStream transformedResultStream) throws ErrorMappingsException {
        ServiceErrorMapper sem = new ServiceErrorMapper();
        sem.mapServiceErrors(this.serviceMapping, validatorResultStream, transformedResultStream);
    }
}

