/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.errormappings.processor;

import java.io.File;
import java.lang.reflect.Constructor;
import uk.gov.hmrc.aspire.esps.common.schema.XMLSchemaInvalidException;
import uk.gov.hmrc.aspire.esps.common.schema.XMLSchemaValidator;
import uk.gov.hmrc.aspire.esps.validator.config.GlobalConfiguration;
import uk.gov.hmrc.aspire.esps.validator.config.ServiceConfiguration;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ErrorMappingsException;
import uk.gov.hmrc.aspire.esps.validator.errormappings.processor.DefaultServiceErrorMappingProcessor;
import uk.gov.hmrc.aspire.esps.validator.errormappings.processor.IServiceErrorMappingProcessor;

public class ServiceErrorMappingProcessorFactory {
    private GlobalConfiguration globalConfiguration;

    public ServiceErrorMappingProcessorFactory(GlobalConfiguration globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
    }

    private String getGlobalErrorMappingSchema() throws ErrorMappingsException {
        String globalErrorMappingSchema = this.globalConfiguration.getInternalSchema("http://www.hmrc.gov.uk/internal/servicemapping/1");
        if (globalErrorMappingSchema == null) {
            throw new ErrorMappingsException("Could not find internal errormappings schema for uri = http://www.hmrc.gov.uk/internal/servicemapping/1");
        }
        return globalErrorMappingSchema;
    }

    public IServiceErrorMappingProcessor createServiceErrorMappingProcessor(ServiceConfiguration serviceConfig) throws ErrorMappingsException {
        IServiceErrorMappingProcessor processor = null;
        File serviceErrorMappingFile = this.getServiceErrorMappingFile(serviceConfig);
        if (serviceErrorMappingFile != null) {
            this.validateErrorMapping(serviceConfig, serviceErrorMappingFile);
            processor = serviceConfig.getErrorMappingProcessor() != null ? this.instantiateProcessor(serviceConfig) : new DefaultServiceErrorMappingProcessor(serviceConfig, serviceErrorMappingFile);
        }
        return processor;
    }

    private File getServiceErrorMappingFile(ServiceConfiguration serviceConfig) throws ErrorMappingsException {
        File errorMappingFile = null;
        if (serviceConfig.getErrorMappingFileName() != null && serviceConfig.getErrorMappingFileName().length() > 0) {
            File rimDir = new File(serviceConfig.getRimArtefactsDirectory());
            errorMappingFile = new File(rimDir, serviceConfig.getErrorMappingFileName());
        } else {
            File[] files;
            for (File f : files = new File(serviceConfig.getRimArtefactsDirectory()).listFiles()) {
                String filename;
                if (!f.isFile() || !f.getAbsolutePath().endsWith(".xml") || (filename = f.getAbsolutePath()).indexOf("Error_Mapping.xml") < 0) continue;
                errorMappingFile = f;
                break;
            }
        }
        return errorMappingFile;
    }

    private void validateErrorMapping(ServiceConfiguration serviceConfig, File serviceErrorMappingFile) throws ErrorMappingsException {
        File errorMappingSchemaFile;
        if (serviceConfig.isErrorMappingPresent()) {
            errorMappingSchemaFile = new File(serviceConfig.getErrorMappingSchemaLocation());
        } else {
            String globalErrorMappingSchema = this.getGlobalErrorMappingSchema();
            errorMappingSchemaFile = new File(globalErrorMappingSchema);
        }
        XMLSchemaValidator sv = new XMLSchemaValidator();
        try {
            sv.validate(serviceErrorMappingFile, errorMappingSchemaFile);
        }
        catch (XMLSchemaInvalidException e1) {
            throw new ErrorMappingsException("Schema validation failure. See wrapped exceptions for details.", e1);
        }
    }

    private IServiceErrorMappingProcessor instantiateProcessor(ServiceConfiguration serviceConfig) throws ErrorMappingsException {
        IServiceErrorMappingProcessor processor = null;
        String processorClassName = serviceConfig.getErrorMappingProcessor();
        try {
            Class<?> processorClass = Class.forName(processorClassName);
            Class[] constructorParams = new Class[]{ServiceConfiguration.class};
            try {
                Constructor<?> constructor = processorClass.getConstructor(constructorParams);
                processor = (IServiceErrorMappingProcessor)constructor.newInstance(serviceConfig);
            }
            catch (NoSuchMethodException nsmE) {
                processor = (IServiceErrorMappingProcessor)processorClass.newInstance();
            }
        }
        catch (Exception e) {
            throw new ErrorMappingsException("Unable to instantiate ServiceErrorMappingProcessor class [" + processorClassName + "]", e);
        }
        return processor;
    }
}

