/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.errormappings.v2;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.gov.hmrc.aspire.esps.validator.config.ServiceConfiguration;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ErrorMappingsException;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingEntry;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingProcessor;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingSearchKey;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingUtil;

public class DefaultErrorMappingProcessor
extends ErrorMappingProcessor {
    private Namespace errorNamespace;
    private int totalErrorCount;
    private final Set<ErrorMappingSearchKey> mappingEntryKeySet = new HashSet<ErrorMappingSearchKey>();
    private final Set<Element> duplicateErrorElements = new LinkedHashSet<Element>();

    public DefaultErrorMappingProcessor(ServiceConfiguration serviceConfiguration) throws ErrorMappingsException {
        super(serviceConfiguration);
    }

    @Override
    protected void processErrorResponse(Element rootElement, Element errorResponseElement) throws ErrorMappingsException {
        this.reset();
        Namespace validationNamespace = rootElement.getNamespace();
        this.errorNamespace = errorResponseElement.getNamespace();
        List elements = errorResponseElement.getChildren("Error", this.errorNamespace);
        this.totalErrorCount = elements.size();
        for (Element currErrorElement : elements) {
            ErrorMappingEntry errorMapping = this.getErrorMapping(currErrorElement, this.errorNamespace);
            if (errorMapping == null) continue;
            this.processErrorMapping(currErrorElement, errorMapping);
        }
        this.filterErrorResults();
        this.rewriteMessageCount(rootElement, validationNamespace, this.totalErrorCount);
        this.cleanup();
    }

    private void processErrorMapping(Element errorElement, ErrorMappingEntry errorMapping) throws ErrorMappingsException {
        String location = errorElement.getChildText("Location", this.errorNamespace);
        if (ErrorMappingUtil.isSchemaError(errorMapping.getNumber())) {
            ErrorMappingSearchKey searchKey = new ErrorMappingSearchKey(location, errorMapping);
            if (!this.mappingEntryKeySet.contains(searchKey)) {
                this.mappingEntryKeySet.add(searchKey);
                this.applyMapping(this.errorNamespace, errorElement, errorMapping);
            } else {
                this.duplicateErrorElements.add(errorElement);
            }
        } else {
            this.applyMapping(this.errorNamespace, errorElement, errorMapping);
        }
    }

    private void reset() {
        this.totalErrorCount = 0;
        this.errorNamespace = null;
    }

    private void filterErrorResults() {
        this.removeDuplicates();
    }

    private void removeDuplicates() {
        for (Element errorElement : this.duplicateErrorElements) {
            errorElement.detach();
            --this.totalErrorCount;
        }
    }

    private void rewriteMessageCount(Element rootElement, Namespace validationNamespace, int totalErrorCount) {
        Element misElement = rootElement.getChild("MIS", validationNamespace);
        if (misElement != null) {
            List elements = misElement.getChildren();
            for (Element currElement : elements) {
                if (!"ErrorCount".equals(currElement.getName())) continue;
                currElement.setText(String.valueOf(totalErrorCount));
                break;
            }
        }
    }

    private void cleanup() {
        this.clearCollections();
    }

    private void clearCollections() {
        this.mappingEntryKeySet.clear();
        this.duplicateErrorElements.clear();
    }
}

