/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.errormappings.v2;

import org.jdom.Element;
import org.jdom.Namespace;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingEntry;

public class ErrorMappingInstance {
    private Integer number;
    private String type;
    private String text;
    private String location;
    private String originalErrorLocation;

    public ErrorMappingInstance(Element error, Namespace errorNamespace, ErrorMappingEntry mapping) {
        if (mapping.getNumber() != null) {
            this.number = mapping.getNumber();
        } else if (error != null) {
            try {
                this.number = new Integer(error.getChildText("Number", errorNamespace));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (mapping.getType() != null) {
            this.type = mapping.getType();
        } else if (error != null) {
            this.type = error.getChildText("Type", errorNamespace);
        }
        if (mapping.getText() != null) {
            this.text = mapping.getText();
        } else if (error != null) {
            this.text = error.getChildText("Text", errorNamespace);
        }
        if (mapping.getLocation() != null) {
            this.location = mapping.getLocation();
        } else if (error != null) {
            this.location = error.getChildText("Location", errorNamespace);
        }
        if (error != null) {
            this.originalErrorLocation = error.getChildText("Location", errorNamespace);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.originalErrorLocation == null ? 0 : this.originalErrorLocation.hashCode());
        result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorMappingInstance other = (ErrorMappingInstance)obj;
        if (this.originalErrorLocation == null ? other.originalErrorLocation != null : !this.originalErrorLocation.equals(other.originalErrorLocation)) {
            return false;
        }
        if (this.number == null ? other.number != null : !this.number.equals(other.number)) {
            return false;
        }
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getOriginalErrorLocation() {
        return this.originalErrorLocation;
    }

    public void setOriginalErrorLocation(String originalErrorLocation) {
        this.originalErrorLocation = originalErrorLocation;
    }
}

