/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.errormappings.v2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.gov.hmrc.aspire.esps.validator.config.ServiceConfiguration;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ErrorMappingsException;
import uk.gov.hmrc.aspire.esps.validator.errormappings.processor.ServiceErrorMappingProcessor;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingEntry;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingLookupData;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingUtil;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappings;

public abstract class ErrorMappingProcessor
extends ServiceErrorMappingProcessor {
    private ErrorMappings mappings = null;

    public ErrorMappingProcessor(ServiceConfiguration serviceConfiguration) throws ErrorMappingsException {
        super(serviceConfiguration);
        if (serviceConfiguration == null) {
            throw new NullPointerException("serviceConfiguration");
        }
        String filename = serviceConfiguration.getErrorMappingFileName();
        String artefactsDir = serviceConfiguration.getRimArtefactsDirectory();
        if (filename == null || filename.trim().length() == 0) {
            throw new ErrorMappingsException("Error mapping configuration file name is missing or empty: " + filename);
        }
        if (artefactsDir == null || artefactsDir.trim().length() == 0) {
            throw new ErrorMappingsException("RIM artefacts directory path is missing or empty: " + artefactsDir);
        }
        this.mappings = new ErrorMappings(new File(artefactsDir, filename));
    }

    @Override
    public void process(InputStream validatorResultStream, OutputStream transformedResultStream) throws ErrorMappingsException {
        Document doc = ErrorMappingUtil.getStreamAsDocument(validatorResultStream);
        Element root = doc.getRootElement();
        List elements = root.getChildren();
        Element errorResponseElement = null;
        for (Element currElement : elements) {
            if (!"ErrorResponse".equals(currElement.getName())) continue;
            errorResponseElement = currElement;
            break;
        }
        if (errorResponseElement != null) {
            this.processErrorResponse(root, errorResponseElement);
        }
        ErrorMappingUtil.writeResponseToOutputStream(doc, transformedResultStream);
    }

    protected abstract void processErrorResponse(Element var1, Element var2) throws ErrorMappingsException;

    public ErrorMappings getMappings() {
        return this.mappings;
    }

    protected void applyMapping(Namespace namespace, Element parent, ErrorMappingEntry mapping) throws ErrorMappingsException {
        Element child = null;
        if (mapping != null && parent != null) {
            if (mapping.getRaisedBy() != null && (child = parent.getChild("RaisedBy", namespace)) != null) {
                child.setText(mapping.getRaisedBy());
            }
            if (mapping.getType() != null && (child = parent.getChild("Type", namespace)) != null) {
                child.setText(mapping.getType());
            }
            if (mapping.getNumber() != null && (child = parent.getChild("Number", namespace)) != null) {
                child.setText(mapping.getNumber().toString());
            }
            if (mapping.getText() != null && (child = parent.getChild("Text", namespace)) != null) {
                child.setText(mapping.getText());
            }
            if (mapping.getLocation() != null && (child = parent.getChild("Location", namespace)) != null) {
                child.setText(mapping.getLocation());
            }
            if (mapping.getApplicationFragment() != null) {
                ByteArrayInputStream fragmentStream = new ByteArrayInputStream(mapping.getApplicationFragment().getBytes());
                Document doc = ErrorMappingUtil.getStreamAsDocument(fragmentStream);
                ErrorMappingUtil.copyToChildElement(doc.getRootElement(), parent, "Application", namespace);
            }
        }
    }

    protected ErrorMappingEntry getErrorMapping(Element errorElement, Namespace errorNamespace) {
        Integer number = Integer.valueOf(errorElement.getChildText("Number", errorNamespace));
        String location = errorElement.getChildText("Location", errorNamespace);
        String text = errorElement.getChildText("Text", errorNamespace);
        String parsedLocation = ErrorMappingUtil.removeOrdinalNumbers(location);
        ErrorMappingEntry errorMapping = this.getMappings().get(new ErrorMappingLookupData(number, text, parsedLocation));
        return errorMapping;
    }
}

