/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.errormappings.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ErrorMappingsException;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingConstants;

public final class ErrorMappingUtil {
    private ErrorMappingUtil() {
    }

    public static void copyToChildElement(Element source, Element destinationParent, String destinationElementName, Namespace destinationElementNamespace) {
        Element destination = destinationParent.getChild(destinationElementName, destinationElementNamespace);
        if (destination == null) {
            destination = new Element(destinationElementName, destinationElementNamespace);
            destinationParent.addContent((Content)destination);
        } else {
            destination.removeContent();
        }
        List sourceChildElements = source.getChildren();
        for (Element currElement : sourceChildElements) {
            currElement.setNamespace(destinationElementNamespace);
            destination.addContent((Content)((Element)currElement.clone()));
        }
    }

    public static Document getStreamAsDocument(InputStream in) throws ErrorMappingsException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(in);
        }
        catch (Exception e) {
            throw new ErrorMappingsException("There was a problem parsing xml from the Stream. See wrapped exception for details.", e);
        }
        return doc;
    }

    public static String getOrdinalNumber(String xpath, String elementName) {
        int endIndex;
        int startIndex;
        String ordinalValue = null;
        if (xpath != null && xpath.trim().length() > 0 && elementName != null && elementName.trim().length() > 0 && (startIndex = xpath.indexOf(elementName + "[")) > -1 && (endIndex = xpath.indexOf(93, startIndex += elementName.length() + 1)) > -1) {
            ordinalValue = xpath.substring(startIndex, endIndex);
        }
        return ordinalValue;
    }

    public static String removeOrdinalNumbers(String xpath) {
        String result = null;
        if (xpath != null) {
            result = xpath.replaceAll("\\[[0-9]*\\]", "");
        }
        return result;
    }

    public static void setDescendantElementText(Element rootElement, String[] descendantTree, String[] namespaces, String newText) {
        Element element = ErrorMappingUtil.getDescendantElement(rootElement, descendantTree, namespaces);
        if (element != null) {
            element.setText(newText);
        }
    }

    public static Element getDescendantElement(Element parentElement, String[] descendantTree, String[] namespaces) {
        return ErrorMappingUtil.getDescendantElement(parentElement, descendantTree, namespaces, 0);
    }

    private static Element getDescendantElement(Element parentElement, String[] descendantTree, String[] namespaces, int index) {
        Element child = null;
        if (parentElement != null && descendantTree != null && (child = namespaces != null && namespaces[index] != null ? parentElement.getChild(descendantTree[index], Namespace.getNamespace((String)namespaces[index])) : parentElement.getChild(descendantTree[index])) != null && ++index < descendantTree.length) {
            child = ErrorMappingUtil.getDescendantElement(child, descendantTree, namespaces, index);
        }
        return child;
    }

    public static String getDescendantElementText(Element parentElement, String[] descendantTree, String[] namespaces) {
        String text = null;
        Element element = ErrorMappingUtil.getDescendantElement(parentElement, descendantTree, namespaces, 0);
        if (element != null) {
            text = element.getText();
        }
        return text;
    }

    public static void translateStructuralInvalidContentError(Element errorElement, Namespace errorNamespace, Namespace validationNamespace) {
        String devMsgTxt;
        Element messagesElem;
        Element applicationElem;
        Integer number = Integer.valueOf(errorElement.getChildText("Number", errorNamespace));
        if (number == 4065 && (applicationElem = errorElement.getChild("Application", errorNamespace)) != null && (messagesElem = applicationElem.getChild("Messages", validationNamespace)) != null && (devMsgTxt = messagesElem.getChildText("DeveloperMessage", validationNamespace)) != null && devMsgTxt.startsWith("cvc-complex-type.2.4.a")) {
            Element locationElem = errorElement.getChild("Location", errorNamespace);
            String parentXpath = locationElem.getText().substring(0, locationElem.getText().lastIndexOf(47));
            locationElem.setText(parentXpath);
            Element numberElem = errorElement.getChild("Number", errorNamespace);
            Element textElem = errorElement.getChild("Text", errorNamespace);
            if (numberElem != null) {
                numberElem.setText(String.valueOf(4066));
            }
            if (textElem != null) {
                textElem.setText("Incomplete content found at element");
            }
        }
    }

    public static void translateEmptyElementError(Element errorElement, Namespace errorNamespace, Namespace validationNamespace) {
        Element messagesElem;
        Element applicationElem;
        String number = errorElement.getChildText("Number", errorNamespace);
        if ("4065|4080|4020|4000|4082".indexOf(number) > -1 && (applicationElem = errorElement.getChild("Application", errorNamespace)) != null && (messagesElem = applicationElem.getChild("Messages", validationNamespace)) != null) {
            String devMsgTxt = messagesElem.getChildText("DeveloperMessage", validationNamespace);
            boolean isEmptyElement = false;
            for (int index = 0; index < ErrorMappingConstants.EMPTY_ELEMENT_ERROR_INDICATORS.length; ++index) {
                if (!devMsgTxt.startsWith(ErrorMappingConstants.EMPTY_ELEMENT_ERROR_INDICATORS[index])) continue;
                isEmptyElement = true;
                break;
            }
            if (isEmptyElement) {
                Element numberElem = errorElement.getChild("Number", errorNamespace);
                Element textElem = errorElement.getChild("Text", errorNamespace);
                if (numberElem != null) {
                    numberElem.setText(String.valueOf(4085));
                }
                if (textElem != null) {
                    textElem.setText(String.valueOf("Value '' doesn't have the correct format"));
                }
            }
        }
    }

    public static void writeResponseToOutputStream(Document doc, OutputStream out) throws ErrorMappingsException {
        Format format = Format.getPrettyFormat();
        XMLOutputter serializer = new XMLOutputter(format);
        try {
            serializer.output(doc, out);
        }
        catch (IOException e) {
            throw new ErrorMappingsException("There was a problem trying to write contents of JDOM Document to the output stream following errors match. See wrapped exception for details.", e);
        }
    }

    public static boolean isSchemaError(Integer errorNumber) {
        boolean result = false;
        if (errorNumber != null) {
            for (Integer schemaError : ErrorMappingConstants.SCHEMA_ERRORS) {
                if (!errorNumber.equals(schemaError)) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

