/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.errormappings.v2;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ErrorMappingsException;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingEntry;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingLookupData;
import uk.gov.hmrc.internal.errormapping.x1.BaseErrorType;
import uk.gov.hmrc.internal.errormapping.x1.ErrorMappingDocument;
import uk.gov.hmrc.internal.errormapping.x1.Mapping;

public class ErrorMappings {
    protected Map<String, Set<ErrorMappingEntry>> errorMappingEntries = new HashMap<String, Set<ErrorMappingEntry>>(100);

    public ErrorMappings(File mappingConfigFile) throws ErrorMappingsException {
        ErrorMappingDocument mappingDoc = null;
        if (mappingConfigFile == null) {
            throw new ErrorMappingsException("Error Mapping configuration file is null");
        }
        try {
            mappingDoc = ErrorMappingDocument.Factory.parse(mappingConfigFile);
        }
        catch (IOException ioe) {
            throw new ErrorMappingsException("Failed to parse Error Mapping configuration file: " + mappingConfigFile.getAbsolutePath(), ioe);
        }
        catch (XmlException xmle) {
            throw new ErrorMappingsException("Failed to parse Error Mapping configuration file: " + mappingConfigFile.getAbsolutePath(), xmle);
        }
        try {
            ErrorMappingLookupData lookupData = new ErrorMappingLookupData(null, null, null);
            for (Mapping mapping : mappingDoc.getErrorMapping().getMappingArray()) {
                lookupData.number = mapping.getNumber() != null ? Integer.valueOf(mapping.getNumber().intValue()) : null;
                lookupData.text = mapping.getText();
                lookupData.location = mapping.getLocation();
                String applicationFragment = null;
                if (mapping.getError() != null) {
                    BaseErrorType error = mapping.getError();
                    if (error.getNewApplication() != null) {
                        XmlOptions ops = new XmlOptions();
                        ops.setSaveInner();
                        applicationFragment = error.getNewApplication().xmlText(ops);
                    }
                    ErrorMappingEntry entry = new ErrorMappingEntry(error.getNewRaisedBy(), error.getNewNumber() != null ? Integer.valueOf(error.getNewNumber().intValue()) : null, error.getNewType(), error.getNewText(), error.getNewLocation(), applicationFragment, lookupData.clone());
                    this.put(lookupData.location, entry);
                }
                if (mapping.getErrors() == null) continue;
                for (Mapping.Errors.Error currError : mapping.getErrors().getErrorArray()) {
                    if (currError.getNumber() != null) {
                        Integer n = lookupData.number = currError.getNumber() != null ? Integer.valueOf(currError.getNumber().intValue()) : null;
                    }
                    if (currError.getNewApplication() != null) {
                        XmlOptions ops = new XmlOptions();
                        ops.setSaveInner();
                        applicationFragment = currError.getNewApplication().xmlText(ops);
                    }
                    ErrorMappingEntry entry = new ErrorMappingEntry(currError.getNewRaisedBy(), currError.getNewNumber() != null ? Integer.valueOf(currError.getNewNumber().intValue()) : null, currError.getNewType(), currError.getNewText(), currError.getNewLocation(), applicationFragment, lookupData.clone());
                    this.put(lookupData.location, entry);
                }
            }
        }
        catch (NullPointerException npe) {
            throw new ErrorMappingsException("Unexpected structure of Error Mapping configuration file: " + mappingConfigFile.getAbsolutePath(), npe);
        }
    }

    void put(String key, ErrorMappingEntry value) {
        Set<ErrorMappingEntry> subset = this.errorMappingEntries.get(key);
        if (subset == null) {
            subset = new HashSet<ErrorMappingEntry>();
            subset.add(value);
            this.errorMappingEntries.put(key, subset);
        } else {
            subset.add(value);
        }
    }

    public ErrorMappingEntry get(ErrorMappingLookupData lookupData) {
        ErrorMappingEntry entry = null;
        Set<ErrorMappingEntry> subset = this.errorMappingEntries.get(lookupData.location);
        Set<ErrorMappingEntry> nullLocationSubset = this.errorMappingEntries.get(null);
        if ((subset = ErrorMappings.mergeSets(subset, nullLocationSubset)) != null) {
            for (ErrorMappingEntry currEntry : subset) {
                if (!currEntry.isMatch(lookupData)) continue;
                if (entry == null) {
                    entry = currEntry;
                    continue;
                }
                if (currEntry.compareLookupData(lookupData) <= entry.compareLookupData(lookupData)) continue;
                entry = currEntry;
            }
        }
        return entry;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Error Mappings:\n");
        if (this.errorMappingEntries.size() > 0) {
            for (String key : this.errorMappingEntries.keySet()) {
                str.append("    KEY: ");
                str.append(key != null ? key.toString() : null);
                str.append("\n");
                for (ErrorMappingEntry entry : this.errorMappingEntries.get(key)) {
                    str.append("        -> MAPPING[");
                    str.append(entry.toString());
                    str.append("]\n");
                }
            }
        }
        return str.toString();
    }

    static Set<ErrorMappingEntry> mergeSets(Set<ErrorMappingEntry> setOne, Set<ErrorMappingEntry> setTwo) {
        Set<ErrorMappingEntry> result = null;
        if (setOne != null) {
            if (setTwo != null) {
                setOne.addAll(setTwo);
                result = setOne;
            } else {
                result = setOne;
            }
        } else if (setTwo != null) {
            result = setTwo;
        }
        return result;
    }
}

