/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.errormappings.v2.paye.exb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.gov.hmrc.aspire.esps.validator.config.ServiceConfiguration;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ErrorMappingsException;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingConstants;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingEntry;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingProcessor;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingUtil;

public class PAYEEXBErrorMappingProcessor
extends ErrorMappingProcessor {
    private static final Integer SCHEMA_5030 = 5030;
    private static final String SCHEMA = "schema";
    private static final String BUSINESS = "business";
    private final Set<ErrorMappingSearchKey> mappingEntryKeySet = new HashSet<ErrorMappingSearchKey>();
    private final Set<Element> duplicateErrorElements = new LinkedHashSet<Element>();
    private final List<Element> schemaErrorElements = new LinkedList<Element>();
    private final List<Element> businessErrorElements = new LinkedList<Element>();
    private final Map<String, Element> locationElementMap = new HashMap<String, Element>();
    private int totalErrorCount;
    private Namespace errorNamespace;

    public PAYEEXBErrorMappingProcessor(ServiceConfiguration serviceConfiguration) throws ErrorMappingsException {
        super(serviceConfiguration);
    }

    @Override
    protected void processErrorResponse(Element rootElement, Element errorResponseElement) throws ErrorMappingsException {
        this.reset();
        Namespace validationNamespace = rootElement.getNamespace();
        this.errorNamespace = errorResponseElement.getNamespace();
        List elements = errorResponseElement.getChildren("Error", this.errorNamespace);
        this.totalErrorCount = elements.size();
        for (Element currErrorElement : elements) {
            String newType;
            this.translateGSLErrors(currErrorElement, this.errorNamespace, validationNamespace);
            ErrorMappingEntry errorMapping = this.getErrorMapping(currErrorElement, this.errorNamespace);
            if (errorMapping != null) {
                this.processErrorMapping(currErrorElement, errorMapping);
            }
            if ((newType = currErrorElement.getChildText("Type", this.errorNamespace)) != null && newType.indexOf(SCHEMA) > -1) {
                this.schemaErrorElements.add(currErrorElement);
                continue;
            }
            if (newType == null || newType.indexOf(BUSINESS) <= -1) continue;
            this.businessErrorElements.add(currErrorElement);
        }
        this.filterErrorResults();
        this.rewriteMessageCount(rootElement, validationNamespace, this.totalErrorCount);
        this.cleanup();
    }

    private void processErrorMapping(Element errorElement, ErrorMappingEntry errorMapping) throws ErrorMappingsException {
        String location = errorElement.getChildText("Location", this.errorNamespace);
        Integer number = Integer.valueOf(errorElement.getChildText("Number", this.errorNamespace));
        if (this.isSchemaError(errorMapping.getNumber())) {
            ErrorMappingSearchKey searchKey = new ErrorMappingSearchKey(location, errorMapping);
            if (!this.mappingEntryKeySet.contains(searchKey)) {
                this.mappingEntryKeySet.add(searchKey);
                this.applyMapping(this.errorNamespace, errorElement, errorMapping);
                int mappedNumber = Integer.valueOf(errorElement.getChildText("Number", this.errorNamespace));
                if (mappedNumber == ErrorMappingConstants.SCHEMA_ERROR_EMPTY_ELEMENT || mappedNumber == ErrorMappingConstants.SCHEMA_ERROR_INVALID_FORMAT) {
                    if (this.locationElementMap.containsKey(location)) {
                        if (number == ErrorMappingConstants.SCHEMA_ERROR_EMPTY_ELEMENT) {
                            this.duplicateErrorElements.add(this.locationElementMap.get(location));
                        } else {
                            this.duplicateErrorElements.add(errorElement);
                        }
                    } else {
                        this.locationElementMap.put(location, errorElement);
                    }
                }
            } else {
                this.applyMapping(this.errorNamespace, errorElement, errorMapping);
                this.duplicateErrorElements.add(errorElement);
            }
        } else {
            this.applyMapping(this.errorNamespace, errorElement, errorMapping);
        }
    }

    private void filterErrorResults() {
        this.removeDuplicates();
        this.removeSchemaErrors();
    }

    private void removeDuplicates() {
        for (Element errorElement : this.duplicateErrorElements) {
            errorElement.detach();
            --this.totalErrorCount;
        }
    }

    private void removeSchemaErrors() {
        if (this.schemaErrorElements.size() > 0 && this.businessErrorElements.size() > 0) {
            for (Element currErrorElement : this.schemaErrorElements) {
                currErrorElement.detach();
                --this.totalErrorCount;
            }
        }
    }

    private void translateGSLErrors(Element errorElement, Namespace errorNamespace, Namespace validationNamespace) {
        ErrorMappingUtil.translateStructuralInvalidContentError(errorElement, errorNamespace, validationNamespace);
        ErrorMappingUtil.translateEmptyElementError(errorElement, errorNamespace, validationNamespace);
    }

    private void rewriteMessageCount(Element rootElement, Namespace validationNamespace, int totalErrorCount) {
        Element misElement = rootElement.getChild("MIS", validationNamespace);
        if (misElement != null) {
            List elements = misElement.getChildren();
            for (Element currElement : elements) {
                if (!"ErrorCount".equals(currElement.getName())) continue;
                currElement.setText(String.valueOf(totalErrorCount));
                break;
            }
        }
    }

    private void reset() {
        this.totalErrorCount = 0;
        this.errorNamespace = null;
    }

    private void cleanup() {
        this.clearCollections();
    }

    private void clearCollections() {
        this.mappingEntryKeySet.clear();
        this.duplicateErrorElements.clear();
        this.schemaErrorElements.clear();
        this.businessErrorElements.clear();
        this.locationElementMap.clear();
    }

    private boolean isSchemaError(Integer errorNumber) {
        boolean result = false;
        if (errorNumber != null && (ErrorMappingUtil.isSchemaError(errorNumber) || errorNumber.equals(SCHEMA_5030))) {
            result = true;
        }
        return result;
    }

    private class ErrorMappingSearchKey {
        private Integer number;
        private String type;
        private String text;
        private String location;

        public ErrorMappingSearchKey(String location, ErrorMappingEntry entry) {
            this.number = entry.getNumber();
            this.type = entry.getType();
            this.text = entry.getText();
            this.location = location;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
            result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ErrorMappingSearchKey other = (ErrorMappingSearchKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
                return false;
            }
            if (this.number == null ? other.number != null : !this.number.equals(other.number)) {
                return false;
            }
            if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        private PAYEEXBErrorMappingProcessor getOuterType() {
            return PAYEEXBErrorMappingProcessor.this;
        }
    }
}

