/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.errormappings.v2.sdlt;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.gov.hmrc.aspire.esps.validator.config.ServiceConfiguration;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ErrorMappingsException;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingEntry;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingInstance;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingProcessor;
import uk.gov.hmrc.aspire.esps.validator.errormappings.v2.ErrorMappingUtil;

public class SDLTErrorMappingProcessor
extends ErrorMappingProcessor {
    protected static final String ATTRIBUTE_INDICATOR = "@";
    protected static final String SDLT2_ELEMENT = "SDLT2";
    protected static final String SDLT3_ELEMENT = "AdditionalProperty";
    protected static final String SDLT4_ELEMENT = "SDLT4";
    protected static final String SCHEDULE_OCCURRENCE_ELEMENT = "ScheduleOccurrence";
    protected static final String SDLT_SCHEMA_ERROR_CODE = "6010";
    protected static final String SDLT_ERROR_TYPE = "Business Rule";
    private final Set<ErrorMappingInstance> mappingInstances = new HashSet<ErrorMappingInstance>();
    private final Set<Element> duplicateErrorElements = new LinkedHashSet<Element>();
    private final Set<String> schemaErrorLocations = new HashSet<String>();
    private int totalErrorCount;
    private Namespace errorNamespace;

    public SDLTErrorMappingProcessor(ServiceConfiguration serviceConfiguration) throws ErrorMappingsException {
        super(serviceConfiguration);
    }

    @Override
    public void processErrorResponse(Element rootElement, Element errorResponseElement) throws ErrorMappingsException {
        if (errorResponseElement != null || rootElement == null) {
            this.reset();
            Namespace validationNamespace = rootElement.getNamespace();
            this.errorNamespace = errorResponseElement.getNamespace();
            List elements = errorResponseElement.getChildren("Error", this.errorNamespace);
            this.totalErrorCount = elements.size();
            for (Element currErrorElement : elements) {
                ErrorMappingUtil.translateStructuralInvalidContentError(currErrorElement, this.errorNamespace, validationNamespace);
                ErrorMappingEntry errorMapping = this.getErrorMapping(currErrorElement, this.errorNamespace);
                if (errorMapping != null) {
                    ErrorMappingInstance mappingInstance = this.processErrorMapping(currErrorElement, errorMapping);
                    this.postProcessErrorMapping(currErrorElement, mappingInstance);
                } else {
                    this.schemaDuplicateCheck(currErrorElement);
                }
                this.translateGSLSchemaError(currErrorElement);
            }
            this.removeDuplicates();
            this.updateErrorCount(rootElement);
            this.cleanup();
        }
    }

    private void translateGSLSchemaError(Element errorElement) {
        String type = errorElement.getChildText("Type", this.errorNamespace);
        if (type.equals("schema")) {
            Element child = errorElement.getChild("Type", this.errorNamespace);
            if (child != null) {
                child.setText(SDLT_ERROR_TYPE);
            }
            if ((child = errorElement.getChild("Number", this.errorNamespace)) != null) {
                child.setText(SDLT_SCHEMA_ERROR_CODE);
            }
            if ((child = errorElement.getChild("Location", this.errorNamespace)) != null) {
                String location = child.getText();
                int xpathDelimIndex = (location = ErrorMappingUtil.removeOrdinalNumbers(location)).lastIndexOf("/");
                if (xpathDelimIndex > 0 && location.indexOf(ATTRIBUTE_INDICATOR) > -1) {
                    xpathDelimIndex = location.lastIndexOf("/", xpathDelimIndex - 1);
                }
                if (xpathDelimIndex > -1) {
                    location = location.substring(xpathDelimIndex + 1);
                }
                if (location.contains(":")) {
                    location = location.substring(location.indexOf(":") + 1);
                }
                child.setText(location);
            }
            child = errorElement.getChild("Text", this.errorNamespace);
            String[] xpath = new String[3];
            String[] namespaces = new String[3];
            xpath[0] = "Application";
            namespaces[0] = "http://www.govtalk.gov.uk/CM/errorresponse";
            xpath[1] = "Messages";
            namespaces[1] = "http://www.hmrc.gov.uk/internal/validation/1";
            xpath[2] = "DeveloperMessage";
            namespaces[2] = namespaces[1];
            String developerMessage = ErrorMappingUtil.getDescendantElementText(errorElement, xpath, namespaces);
            if (developerMessage != null && developerMessage.length() > 0) {
                int index = developerMessage.indexOf(": ");
                index = index > -1 ? (index += 2) : 0;
                child.setText(child.getText() + ". " + developerMessage.substring(index));
            }
        }
    }

    private void schemaDuplicateCheck(Element errorElement) {
        Element locationElement;
        String type = errorElement.getChildText("Type", this.errorNamespace);
        if (type.equals("schema") && (locationElement = errorElement.getChild("Location", this.errorNamespace)) != null) {
            String location = locationElement.getText();
            if (this.schemaErrorLocations.contains(location)) {
                this.duplicateErrorElements.add(errorElement);
            } else {
                this.schemaErrorLocations.add(location);
            }
        }
    }

    private ErrorMappingInstance processErrorMapping(Element errorElement, ErrorMappingEntry errorMapping) throws ErrorMappingsException {
        ErrorMappingInstance mappingInstance = new ErrorMappingInstance(errorElement, this.errorNamespace, errorMapping);
        if (ErrorMappingUtil.isSchemaError(mappingInstance.getNumber())) {
            mappingInstance.setText(null);
            mappingInstance.setNumber(null);
            if (!this.mappingInstances.contains(mappingInstance)) {
                this.mappingInstances.add(mappingInstance);
                this.applyMapping(this.errorNamespace, errorElement, errorMapping);
            } else {
                this.duplicateErrorElements.add(errorElement);
            }
        } else {
            this.applyMapping(this.errorNamespace, errorElement, errorMapping);
        }
        return mappingInstance;
    }

    private void postProcessErrorMapping(Element error, ErrorMappingInstance mappingInstance) {
        String ordinalNumber = ErrorMappingUtil.getOrdinalNumber(mappingInstance.getOriginalErrorLocation(), SDLT2_ELEMENT);
        if (ordinalNumber == null && (ordinalNumber = ErrorMappingUtil.getOrdinalNumber(mappingInstance.getOriginalErrorLocation(), SDLT3_ELEMENT)) == null) {
            ordinalNumber = ErrorMappingUtil.getOrdinalNumber(mappingInstance.getOriginalErrorLocation(), SDLT4_ELEMENT);
        }
        if (ordinalNumber == null) {
            ordinalNumber = "1";
        }
        String[] xpath = new String[2];
        String[] namespaces = new String[2];
        xpath[0] = "Application";
        namespaces[0] = "http://www.govtalk.gov.uk/CM/errorresponse";
        xpath[1] = SCHEDULE_OCCURRENCE_ELEMENT;
        namespaces[1] = namespaces[0];
        ErrorMappingUtil.setDescendantElementText(error, xpath, namespaces, ordinalNumber);
    }

    private void removeDuplicates() {
        for (Element errorElement : this.duplicateErrorElements) {
            errorElement.detach();
            --this.totalErrorCount;
        }
    }

    private void reset() {
        this.totalErrorCount = 0;
        this.errorNamespace = null;
    }

    private void cleanup() {
        this.mappingInstances.clear();
        this.duplicateErrorElements.clear();
        this.schemaErrorLocations.clear();
    }

    private void updateErrorCount(Element rootElement) {
        if (this.duplicateErrorElements.size() > 0) {
            String[] xpath = new String[2];
            String[] namespaces = new String[2];
            xpath[0] = "MIS";
            namespaces[0] = "http://www.hmrc.gov.uk/internal/validation/1";
            xpath[1] = "ErrorCount";
            namespaces[1] = "http://www.govtalk.gov.uk/taxation/common/validation-MIS/1";
            ErrorMappingUtil.setDescendantElementText(rootElement, xpath, namespaces, String.valueOf(this.totalErrorCount));
        }
    }

    public static void main(String[] args) {
        String location = "/AAAA[1]/BBBBB[1]/things:CCCCC[4]/stuff:DDDDD/@EEEEE";
        int xpathDelimIndex = (location = ErrorMappingUtil.removeOrdinalNumbers(location)).lastIndexOf("/");
        if (xpathDelimIndex > 0 && location.indexOf(ATTRIBUTE_INDICATOR) > -1) {
            xpathDelimIndex = location.lastIndexOf("/", xpathDelimIndex - 1);
        }
        if (xpathDelimIndex > -1) {
            location = location.substring(xpathDelimIndex + 1);
        }
        if (location.contains(":")) {
            location = location.substring(location.indexOf(":") + 1);
        }
        System.out.println(location);
    }
}

