/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import uk.gov.hmrc.aspire.esps.validator.ValidationSummary;
import uk.gov.hmrc.aspire.esps.validator.Validator;
import uk.gov.hmrc.aspire.esps.validator.ValidatorException;

public class Main {
    public static void main(String[] args) throws ValidatorException {
        File configFile;
        String configFilePath = System.getProperty("configFile");
        if (configFilePath == null) {
            System.out.println("ConfigFile path property not set.");
            System.exit(0);
        }
        if (!(configFile = new File(configFilePath)).isFile()) {
            System.out.println("Invalid Config file parameter supplied.");
            System.exit(0);
        }
        if (args.length != 2) {
            StringBuffer usage = new StringBuffer();
            usage.append("Usage:-");
            usage.append("\n\n");
            usage.append("Main <InputXMLFile> <OutputXMLFile>");
            usage.append("\n");
            usage.append("--OR--");
            usage.append("\n");
            usage.append("Main <InputDirectory> <OutputDirectory>");
            usage.append("\n\n");
            System.out.println(usage.toString());
            System.exit(0);
        }
        File inFile = new File(args[0]);
        File outFile = new File(args[1]);
        HashMap<String, File> params = new HashMap<String, File>();
        params.put("configFile", configFile);
        Validator.initialise(params);
        if (inFile.isFile()) {
            try {
                Main.doProcessFile(params, inFile, outFile);
            }
            catch (ValidatorException e) {
                e.printStackTrace();
            }
        } else if (inFile.isDirectory()) {
            try {
                Main.doProcessDirectory(params, inFile, outFile);
            }
            catch (ValidatorException e) {
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("First input parameter must either be an xml file or a directory.");
        }
    }

    private static void doProcessDirectory(Map params, File inDir, File outDir) throws ValidatorException {
        if (!inDir.exists()) {
            throw new RuntimeException("Input directory " + inDir.getAbsolutePath() + " does not exist.");
        }
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        if (!outDir.isDirectory()) {
            throw new RuntimeException("Output directory not found:  " + outDir);
        }
        File[] files = inDir.listFiles();
        for (int j = 0; j < files.length; ++j) {
            File xmlFile = files[j];
            File outFile = null;
            if (xmlFile.isDirectory() || !xmlFile.getName().endsWith(".xml")) continue;
            String outFilename = xmlFile.getName().replaceAll(".xml", "_response.xml");
            outFile = new File(outDir.getAbsoluteFile() + "/" + outFilename);
            Main.doValidation(params, xmlFile, outFile);
        }
    }

    private static void doProcessFile(Map params, File inFile, File outFile) throws ValidatorException {
        if (!inFile.exists()) {
            System.out.println("Input file " + inFile.getAbsolutePath() + " does not exist.");
            System.exit(0);
        }
        if (!inFile.getName().endsWith("xml")) {
            System.out.println("Invalid input file parameter supplied.");
            System.exit(0);
        }
        if (outFile.getAbsoluteFile().equals(inFile.getAbsoluteFile())) {
            System.out.println("Output file cannot be same as input file.");
            System.exit(0);
        }
        Main.doValidation(params, inFile, outFile);
    }

    private static void doValidation(Map params, File inFile, File outFile) throws ValidatorException {
        ValidationSummary summary = null;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(inFile);
            out = new FileOutputStream(outFile);
            System.out.println("infile = " + inFile.getAbsolutePath());
            Validator validator = new Validator();
            summary = validator.validate(in, out, null);
            System.out.println("outfile = " + outFile.getAbsolutePath());
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ValidatorException e) {
            e.printStackTrace();
        }
    }
}

