/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.standalone;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import uk.gov.hmrc.aspire.esps.validator.Validator;
import uk.gov.hmrc.aspire.esps.validator.ValidatorException;
import uk.gov.hmrc.aspire.esps.validator.standalone.RunnableValidator;

public class MultiThreadedTester {
    public static void main(String[] args) throws ValidatorException {
        File configFile;
        String configFilePath;
        if (args.length != 3) {
            StringBuffer usage = new StringBuffer();
            usage.append("Usage:-");
            usage.append("\n\n");
            usage.append("MultiThreadedTester <InputDirectory> <OutputDirectory> <NumberOfThreads>");
            usage.append("\n\n");
            System.out.println(usage.toString());
            System.exit(0);
        }
        if ((configFilePath = System.getProperty("configFile")) == null) {
            System.out.println("ConfigFile path property not set.");
            System.exit(0);
        }
        if (!(configFile = new File(configFilePath)).isFile()) {
            System.out.println("Invalid Config file parameter supplied.");
            System.exit(0);
        }
        Validator.initialise(configFile);
        File inDir = new File(args[0]);
        File outDir = new File(args[1]);
        int numberOfThreads = Integer.parseInt(args[2]);
        if (!inDir.isDirectory()) {
            throw new RuntimeException(inDir.getAbsolutePath() + " is not a direcory");
        }
        if (!inDir.exists()) {
            throw new RuntimeException("Input directory " + inDir.getAbsolutePath() + " does not exist.");
        }
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        if (!outDir.isDirectory()) {
            throw new RuntimeException("Output directory not found:  " + outDir);
        }
        ExecutorService exec = Executors.newFixedThreadPool(numberOfThreads);
        File[] files = inDir.listFiles();
        for (int j = 0; j < files.length; ++j) {
            File xmlFile = files[j];
            File outFile = null;
            if (xmlFile.isDirectory() || !xmlFile.getName().endsWith(".xml")) continue;
            String outFilename = xmlFile.getName().replaceAll(".xml", "_response.xml");
            outFile = new File(outDir.getAbsoluteFile() + "/" + outFilename);
            exec.execute(new RunnableValidator(xmlFile, outFile));
        }
        exec.shutdown();
        System.out.println("Threads scheduled ok.");
    }
}

