/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.standalone;

import com.gsl.schematron.SchematronCompiler;
import com.gsl.schematron.validator.api.SchematronValidatorFactories;
import com.gsl.schematron.validator.api.SchematronValidatorFactory;
import com.gsl.schematron.validator.api.SchematronValidatorParams;
import com.gsl.schematron.validator.api.ValidationType;
import java.io.File;
import java.util.logging.Level;

public class PrecompileBusinessRules {
    public static void main(String[] args) {
        if (args.length != 2) {
            StringBuffer usage = new StringBuffer();
            usage.append("Usage:-");
            usage.append("\n\n");
            usage.append("PrecompileBusinessRules <RIMArtefactsDirectory> <OutputDirectory>");
            usage.append("\n\n");
            System.out.println(usage.toString());
            System.exit(0);
        }
        String artefactsDirectory = args[0];
        String outputDirectory = args[1];
        File infile = new File(artefactsDirectory);
        if (!infile.exists()) {
            System.out.println("Input artefacts directory " + artefactsDirectory + " does not exist");
            System.exit(1);
        }
        if (!infile.isDirectory()) {
            System.out.println(artefactsDirectory + " is not a valid directory");
            System.exit(1);
        }
        System.out.println("Input artefacts directory = " + infile.getAbsolutePath());
        File outfile = new File(outputDirectory);
        if (!outfile.exists()) {
            System.out.println("Output directory " + outputDirectory + " does not exist");
            System.exit(1);
        }
        if (!outfile.isDirectory()) {
            System.out.println(outputDirectory + " is not a valid directory");
            System.exit(1);
        }
        System.out.println("Output directory for compiled rules = " + outfile.getAbsolutePath());
        SchematronValidatorParams params = new SchematronValidatorParams();
        params.setTemporaryDirpath("/temp");
        params.setRIMArtefactsDirectory("/any/old/directory");
        params.setLoggingLevel(Level.OFF);
        params.setValidationType(ValidationType.COMPLETE);
        params.setMaxErrors(100);
        SchematronValidatorFactory validatorFactory = SchematronValidatorFactories.createDynamicCompilingValidatorFactory((SchematronValidatorParams)params);
        System.out.println("Using GSL version " + validatorFactory.getVersionNumber());
        validatorFactory = null;
        System.out.println("Starting business rule compilation.....");
        SchematronCompiler.main((String[])new String[]{artefactsDirectory, outputDirectory});
        System.out.println("Finished business rule compilation.....");
    }
}

