/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.gov.hmrc.aspire.esps.validator.Validator;
import uk.gov.hmrc.aspire.esps.validator.ValidatorException;

public class RunnableValidator
implements Runnable {
    private File inFile = null;
    private File outFile = null;

    public RunnableValidator(File inFile, File outFile) {
        this.inFile = inFile;
        this.outFile = outFile;
    }

    @Override
    public void run() {
        try {
            this.doValidation(this.inFile, this.outFile);
        }
        catch (ValidatorException e) {
            e.printStackTrace();
        }
    }

    private void doValidation(File inFile, File outFile) throws ValidatorException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(inFile);
            out = new FileOutputStream(outFile);
            System.out.println("Thread = " + Thread.currentThread().getId() + ", Input = " + inFile.getAbsolutePath());
            Validator validator = new Validator();
            validator.validate(in, out, null);
            System.out.println("Thread = " + Thread.currentThread().getId() + ", Response = " + outFile.getAbsolutePath());
            out.flush();
            ((OutputStream)out).close();
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

