/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.standalone;

import com.gsl.docValidator.ValidationException;
import com.gsl.schematron.validator.api.SchematronValidator;
import com.gsl.schematron.validator.api.SchematronValidatorFactories;
import com.gsl.schematron.validator.api.SchematronValidatorFactory;
import com.gsl.schematron.validator.api.SchematronValidatorParams;
import com.gsl.schematron.validator.api.ValidationType;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import validationResponse.output.ValidationResult;

public class Sample {
    public void doValidation(List<InputStream> inputs) {
        SchematronValidatorParams params = new SchematronValidatorParams();
        params.setTemporaryDirpath("/temp");
        params.setRIMArtefactsDirectory("C:/ESPSValidator/resources/RIMArtefacts/demoService/demoForm/demoYear/demoVersion");
        params.setLoggingLevel(Level.OFF);
        params.setValidationType(ValidationType.COMPLETE);
        params.setMaxErrors(100);
        SchematronValidatorFactory validatorFactory = SchematronValidatorFactories.createClasspathLoadingValidatorFactory((SchematronValidatorParams)params);
        System.out.println("\n*****************************************");
        System.out.println("***** GSL Validator - version: " + validatorFactory.getVersionNumber() + " *****");
        System.out.println("*****************************************\n");
        for (InputStream is : inputs) {
            SchematronValidator validator = validatorFactory.createValidator();
            try {
                ValidationResult result = validator.validateSubmission(is, (OutputStream)System.out);
                System.out.println(result.getProcessingTime());
            }
            catch (ValidationException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        Sample sample = new Sample();
        ArrayList<InputStream> inputs = new ArrayList<InputStream>();
        FileInputStream is = null;
        try {
            is = new FileInputStream("C:/ESPSValidator/testdata/input/case9003.xml");
            inputs.add(is);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        sample.doValidation(inputs);
    }
}

