/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.gov.hmrc.aspire.esps.validator.ValidationSummary;
import uk.gov.hmrc.aspire.esps.validator.Validator;
import uk.gov.hmrc.aspire.esps.validator.ValidatorException;

public class SampleMain {
    public static void main(String[] args) throws ValidatorException {
        File configFile;
        String configFilePath;
        if (args.length != 2) {
            StringBuffer usage = new StringBuffer();
            usage.append("Usage:-");
            usage.append("\n\n");
            usage.append("SampleMain <InputDirectory> <OutputDirectory>");
            usage.append("\n\n");
            System.out.println(usage.toString());
            System.exit(0);
        }
        if ((configFilePath = System.getProperty("configFile")) == null) {
            System.out.println("ConfigFile path property not set.");
            System.exit(0);
        }
        if (!(configFile = new File(configFilePath)).isFile()) {
            System.out.println("Invalid Config file parameter supplied.");
            System.exit(0);
        }
        Validator.initialise(configFile);
        File inDir = new File(args[0]);
        File outDir = new File(args[1]);
        if (!inDir.isDirectory()) {
            throw new RuntimeException(inDir.getAbsolutePath() + " is not a direcory");
        }
        if (!inDir.exists()) {
            throw new RuntimeException("Input directory " + inDir.getAbsolutePath() + " does not exist.");
        }
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        if (!outDir.isDirectory()) {
            throw new RuntimeException("Output directory not found:  " + outDir);
        }
        File[] files = inDir.listFiles();
        for (int j = 0; j < files.length; ++j) {
            File xmlFile = files[j];
            File outFile = null;
            if (xmlFile.isDirectory() || !xmlFile.getName().endsWith(".xml")) continue;
            String outFilename = xmlFile.getName().replaceAll(".xml", "_response.xml");
            outFile = new File(outDir.getAbsoluteFile() + "/" + outFilename);
            SampleMain.doValidation(xmlFile, outFile);
        }
    }

    private static void doValidation(File inFile, File outFile) throws ValidatorException {
        ValidationSummary summary = null;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(inFile);
            out = new FileOutputStream(outFile);
            System.out.println("infile = " + inFile.getAbsolutePath());
            Validator validator = new Validator();
            summary = validator.validate(in, out, null);
            System.out.println("outfile = " + outFile.getAbsolutePath());
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

