/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.esps.validator.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import uk.gov.hmrc.aspire.esps.validator.Validator;
import uk.gov.hmrc.aspire.esps.validator.ValidatorException;
import uk.gov.hmrc.aspire.esps.validator.config.ServiceKey;
import uk.gov.hmrc.aspire.esps.validator.errormappings.ErrorMappingsCatalogue;
import uk.gov.hmrc.aspire.esps.validator.errormappings.processor.IServiceErrorMappingProcessor;

public class TestErrorMappings {
    public static void main(String[] args) {
        String envelopeURI = "http://www.hmrc.gov.uk/ChRIS/Envelope/2";
        String serviceURI = "http://www.govtalk.gov.uk/taxation/PAYE/MOV/08-09/1";
        try {
            Validator.initialise(new File("C:/HMRCTools/LTS/resources/config/NonConfigurable/validatorConfig.xml"));
            FileInputStream in = null;
            FileOutputStream out = null;
            Object vs = null;
            try {
                in = new FileInputStream("C:/ESPS/CR007/testdata/input/UnitTestSubmission-PAYE-schema_valid-business_invalid-irmark_valid.xml");
                out = new FileOutputStream(new File("C:/ESPS/CR007/testdata/output/UnitTestResponse-PAYE-schema_valid-business_invalid-irmark_valid.xml"));
                Validator validator = new Validator();
                validator.validate(envelopeURI, serviceURI, in, out, null);
                System.out.println("End validation ...");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (ValidatorException e) {
            e.printStackTrace();
        }
    }

    private static void dumpErrorMappingsCatalogue(String namespace) {
        Map<ServiceKey, IServiceErrorMappingProcessor> serviceMappings = ErrorMappingsCatalogue.getInstance().getServiceErrorMappingProcessors();
        Iterator<ServiceKey> it0 = serviceMappings.keySet().iterator();
        System.out.println("***** Number of serviceMappings = " + serviceMappings.size());
        while (it0.hasNext()) {
            ServiceKey uri = it0.next();
            IServiceErrorMappingProcessor sm = serviceMappings.get(uri);
            if (sm != null) continue;
            System.out.println("Did not find any error mappings for " + uri);
        }
    }
}

