/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;

public class ContentTypeAttribute
extends Attribute {
    protected ContentTypeAttribute() {
        this.attrType = CMSObjectIdentifiers.id_contentType;
    }

    protected ContentTypeAttribute(ASN1Sequence aSN1Sequence) {
        this();
        this.attrValues = (DERConstructedSet)aSN1Sequence.getObjectAt(1);
    }

    public ContentTypeAttribute(Attribute attribute) {
        this();
        this.attrValues = attribute.attrValues;
    }

    public ContentTypeAttribute(ContentTypeAttribute contentTypeAttribute) {
        this();
        this.attrValues = contentTypeAttribute.attrValues;
    }

    public ContentTypeAttribute(DERObjectIdentifier dERObjectIdentifier) {
        this();
        this.attrValues = new DERConstructedSet();
        this.attrValues.addObject(dERObjectIdentifier);
    }

    public ContentTypeAttribute(String string) {
        this();
        this.setContentType(string);
    }

    public static Attribute getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ContentTypeAttribute.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static Attribute getInstance(Object object) {
        if (object == null || object instanceof ContentTypeAttribute) {
            return (ContentTypeAttribute)object;
        }
        if (object instanceof Attribute) {
            return new ContentTypeAttribute((Attribute)object);
        }
        if (object instanceof DERObjectIdentifier) {
            return new ContentTypeAttribute((DERObjectIdentifier)object);
        }
        if (object instanceof ASN1Sequence) {
            return new ContentTypeAttribute((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid ContentType: " + object.getClass().getName());
    }

    public String getContentType() {
        return DERObjectIdentifier.getInstance(this.attrValues.getObjectAt(0)).getId();
    }

    private void setContentType(String string) {
        this.attrValues = new DERConstructedSet();
        this.attrValues.addObject(new DERObjectIdentifier(string));
    }
}

