/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.OriginatorInfo;
import org.bouncycastle.asn1.cms.RecipientInfos;
import org.bouncycastle.asn1.cms.UnprotectedAttributes;

public class EnvelopedData
extends CMSObject {
    private CMSVersion version;
    private OriginatorInfo originatorInfo;
    private RecipientInfos recipientInfos;
    private EncryptedContentInfo encryptedContentInfo;
    private UnprotectedAttributes unprotectedAttrs;

    public EnvelopedData(OriginatorInfo originatorInfo, RecipientInfos recipientInfos, EncryptedContentInfo encryptedContentInfo, UnprotectedAttributes unprotectedAttributes) {
        this.setOriginatorInfo(originatorInfo);
        this.setRecipientInfos(recipientInfos);
        this.setEncryptedContentInfo(encryptedContentInfo);
        this.setUnprotectedAttrs(unprotectedAttributes);
        this.setVersion();
    }

    public EnvelopedData(ASN1Sequence aSN1Sequence) {
        int n = 0;
        this.version = CMSVersion.getInstance(aSN1Sequence.getObjectAt(n++));
        DEREncodable dEREncodable = aSN1Sequence.getObjectAt(n++);
        if (dEREncodable instanceof ASN1TaggedObject) {
            this.originatorInfo = OriginatorInfo.getInstance((ASN1TaggedObject)dEREncodable, false);
            dEREncodable = aSN1Sequence.getObjectAt(n++);
        }
        this.recipientInfos = RecipientInfos.getInstance(dEREncodable);
        this.encryptedContentInfo = EncryptedContentInfo.getInstance(aSN1Sequence.getObjectAt(n++));
        if (aSN1Sequence.getSize() > n) {
            this.unprotectedAttrs = UnprotectedAttributes.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n), false);
        }
    }

    public EnvelopedData(EnvelopedData envelopedData) {
        this.originatorInfo = envelopedData.originatorInfo;
        this.recipientInfos = envelopedData.recipientInfos;
        this.encryptedContentInfo = envelopedData.encryptedContentInfo;
        this.unprotectedAttrs = envelopedData.unprotectedAttrs;
    }

    public static EnvelopedData getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return EnvelopedData.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static EnvelopedData getInstance(Object object) {
        if (object == null || object instanceof EnvelopedData) {
            return (EnvelopedData)object;
        }
        if (object instanceof ASN1Sequence) {
            return new EnvelopedData((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid EnvelopedData: " + object.getClass().getName());
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originatorInfo;
    }

    public RecipientInfos getRecipientInfos() {
        return this.recipientInfos;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public UnprotectedAttributes getUnprotectedAttrs() {
        return this.unprotectedAttrs;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        if (this.originatorInfo != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 0, this.originatorInfo.getDERObject()));
        }
        bERConstructedSequence.addObject(this.recipientInfos);
        bERConstructedSequence.addObject(this.encryptedContentInfo);
        if (this.unprotectedAttrs != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 1, this.unprotectedAttrs.getDERObject()));
        }
        return bERConstructedSequence;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    private void setVersion() {
        if (this.originatorInfo != null || this.unprotectedAttrs != null) {
            this.setVersion(new CMSVersion(new BigInteger("2")));
        } else {
            this.setVersion(new CMSVersion(new BigInteger("0")));
        }
    }

    private void setOriginatorInfo(OriginatorInfo originatorInfo) {
        this.originatorInfo = originatorInfo;
    }

    private void setRecipientInfos(RecipientInfos recipientInfos) {
        this.recipientInfos = recipientInfos;
    }

    private void setEncryptedContentInfo(EncryptedContentInfo encryptedContentInfo) {
        this.encryptedContentInfo = encryptedContentInfo;
    }

    private void setUnprotectedAttrs(UnprotectedAttributes unprotectedAttributes) {
        this.unprotectedAttrs = unprotectedAttributes;
    }
}

