/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class KeyEncryptionAlgorithmIdentifier
extends CMSObject {
    private AlgorithmIdentifier alg;

    public KeyEncryptionAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.setAlgorithmIdentifier(algorithmIdentifier);
    }

    public KeyEncryptionAlgorithmIdentifier(ASN1Sequence aSN1Sequence) {
        this(new AlgorithmIdentifier(aSN1Sequence));
    }

    public KeyEncryptionAlgorithmIdentifier(KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithmIdentifier) {
        this.alg = keyEncryptionAlgorithmIdentifier.alg;
    }

    public KeyEncryptionAlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier) {
        this(new AlgorithmIdentifier(dERObjectIdentifier));
    }

    public KeyEncryptionAlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject) {
        this(new AlgorithmIdentifier(dERObjectIdentifier, dERObject));
    }

    public KeyEncryptionAlgorithmIdentifier(String string) {
        this(new AlgorithmIdentifier(new DERObjectIdentifier(string)));
    }

    public static KeyEncryptionAlgorithmIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return new KeyEncryptionAlgorithmIdentifier(AlgorithmIdentifier.getInstance(aSN1TaggedObject, bl));
    }

    public static KeyEncryptionAlgorithmIdentifier getInstance(Object object) {
        if (object == null || object instanceof KeyEncryptionAlgorithmIdentifier) {
            return (KeyEncryptionAlgorithmIdentifier)object;
        }
        return new KeyEncryptionAlgorithmIdentifier(AlgorithmIdentifier.getInstance(object));
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.alg;
    }

    public DERObject getDERObject() {
        return this.alg.getDERObject();
    }

    private void setAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.alg = algorithmIdentifier;
    }
}

