/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.EncryptedKey;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyEncryptionAlgorithmIdentifier;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.SubjectKeyIdentifier;

public class KeyTransRecipientInfo
extends CMSObject {
    private CMSVersion version;
    private RecipientIdentifier rid;
    private KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm;
    private EncryptedKey encryptedKey;

    public KeyTransRecipientInfo(RecipientIdentifier recipientIdentifier, KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithmIdentifier, EncryptedKey encryptedKey) {
        this.setRecipientIdentifier(recipientIdentifier);
        this.setKeyEncryptionAlgorithm(keyEncryptionAlgorithmIdentifier);
        this.setEncryptedKey(encryptedKey);
        this.setVersion();
    }

    public KeyTransRecipientInfo(ASN1Sequence aSN1Sequence) {
        this.version = CMSVersion.getInstance(aSN1Sequence.getObjectAt(0));
        this.rid = RecipientIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.keyEncryptionAlgorithm = KeyEncryptionAlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(2));
        this.encryptedKey = EncryptedKey.getInstance(aSN1Sequence.getObjectAt(3));
    }

    public KeyTransRecipientInfo(KeyTransRecipientInfo keyTransRecipientInfo) {
        this.version = keyTransRecipientInfo.version;
        this.rid = keyTransRecipientInfo.rid;
        this.keyEncryptionAlgorithm = keyTransRecipientInfo.keyEncryptionAlgorithm;
        this.encryptedKey = keyTransRecipientInfo.encryptedKey;
    }

    public static KeyTransRecipientInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return KeyTransRecipientInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static KeyTransRecipientInfo getInstance(Object object) {
        if (object == null || object instanceof KeyTransRecipientInfo) {
            return (KeyTransRecipientInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new KeyTransRecipientInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid KeyTransRecipientInfo: " + object.getClass().getName());
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    public RecipientIdentifier getRecipientIdentifier() {
        return this.rid;
    }

    public KeyEncryptionAlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public EncryptedKey getEncryptedKey() {
        return this.encryptedKey;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        bERConstructedSequence.addObject(this.rid);
        bERConstructedSequence.addObject(this.keyEncryptionAlgorithm);
        bERConstructedSequence.addObject(this.encryptedKey);
        return bERConstructedSequence;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    private void setVersion() {
        DEREncodable dEREncodable = this.rid.getId();
        if (dEREncodable instanceof IssuerAndSerialNumber) {
            this.setVersion(new CMSVersion(new BigInteger("0")));
        } else if (dEREncodable instanceof SubjectKeyIdentifier) {
            this.setVersion(new CMSVersion(new BigInteger("2")));
        }
    }

    private void setRecipientIdentifier(RecipientIdentifier recipientIdentifier) {
        this.rid = recipientIdentifier;
    }

    private void setKeyEncryptionAlgorithm(KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithmIdentifier) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithmIdentifier;
    }

    private void setEncryptedKey(EncryptedKey encryptedKey) {
        this.encryptedKey = encryptedKey;
    }
}

