/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObject;

public class OtherKeyAttribute
extends CMSObject {
    private DERObjectIdentifier keyAttrId;
    private DERObject keyAttr;

    public OtherKeyAttribute(String string, DERObject dERObject) {
        this.setKeyAttributeId(string);
        this.setKeyAttribute(dERObject);
    }

    public OtherKeyAttribute(ASN1Sequence aSN1Sequence) {
        this.keyAttrId = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        if (aSN1Sequence.getSize() > 1) {
            this.keyAttr = (DERObject)aSN1Sequence.getObjectAt(1);
        }
    }

    public OtherKeyAttribute(OtherKeyAttribute otherKeyAttribute) {
        this.keyAttrId = otherKeyAttribute.keyAttrId;
        this.keyAttr = otherKeyAttribute.keyAttr;
    }

    public static OtherKeyAttribute getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return OtherKeyAttribute.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static OtherKeyAttribute getInstance(Object object) {
        if (object == null || object instanceof OtherKeyAttribute) {
            return (OtherKeyAttribute)object;
        }
        if (object instanceof ASN1Sequence) {
            return new OtherKeyAttribute((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid OtherKeyAttribute: " + object.getClass().getName());
    }

    public String getKeyAttributeId() {
        return this.keyAttrId.getId();
    }

    public DERObject getKeyAttribute() {
        return this.keyAttr;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.keyAttrId);
        if (this.keyAttr != null) {
            bERConstructedSequence.addObject(this.keyAttr);
        }
        return bERConstructedSequence;
    }

    private void setKeyAttributeId(String string) {
        this.keyAttrId = new DERObjectIdentifier(string);
    }

    private void setKeyAttribute(DERObject dERObject) {
        this.keyAttr = dERObject;
    }
}

