/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;

public class RC2ParameterVersion
extends CMSObject {
    private DERInteger version;

    public RC2ParameterVersion(BigInteger bigInteger) {
        this.setVersion(bigInteger);
    }

    public RC2ParameterVersion(DERInteger dERInteger) {
        this.version = dERInteger;
    }

    public RC2ParameterVersion(RC2ParameterVersion rC2ParameterVersion) {
        this.version = rC2ParameterVersion.version;
    }

    public static RC2ParameterVersion getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return RC2ParameterVersion.getInstance(DERInteger.getInstance(aSN1TaggedObject, bl));
    }

    public static RC2ParameterVersion getInstance(Object object) {
        if (object == null || object instanceof RC2ParameterVersion) {
            return (RC2ParameterVersion)object;
        }
        if (object instanceof DERInteger) {
            return new RC2ParameterVersion((DERInteger)object);
        }
        throw new IllegalArgumentException("Invalid RC2ParameterVersion: " + object.getClass().getName());
    }

    public BigInteger getVersion() {
        return this.version.getValue();
    }

    public DERObject getDERObject() {
        return this.version;
    }

    private void setVersion(BigInteger bigInteger) {
        this.version = new DERInteger(bigInteger);
    }
}

