/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SubjectKeyIdentifier;

public class SignerIdentifier
extends CMSObject {
    private DEREncodable id;

    public SignerIdentifier(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.setId(issuerAndSerialNumber);
    }

    public SignerIdentifier(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.setId(subjectKeyIdentifier);
    }

    public SignerIdentifier(DERObject dERObject) {
        this.id = dERObject instanceof ASN1TaggedObject ? SubjectKeyIdentifier.getInstance((ASN1TaggedObject)dERObject, false) : IssuerAndSerialNumber.getInstance(dERObject);
    }

    public SignerIdentifier(SignerIdentifier signerIdentifier) {
        this.id = signerIdentifier.id;
    }

    public static SignerIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SignerIdentifier.getInstance(aSN1TaggedObject);
    }

    public static SignerIdentifier getInstance(Object object) {
        if (object == null || object instanceof SignerIdentifier) {
            return (SignerIdentifier)object;
        }
        if (object instanceof IssuerAndSerialNumber) {
            return new SignerIdentifier((IssuerAndSerialNumber)object);
        }
        if (object instanceof SubjectKeyIdentifier) {
            return new SignerIdentifier((SubjectKeyIdentifier)object);
        }
        if (object instanceof DERObject) {
            return new SignerIdentifier((DERObject)object);
        }
        throw new IllegalArgumentException("Invalid SignerIdentifier: " + object.getClass().getName());
    }

    public DEREncodable getId() {
        return this.id;
    }

    public DERObject getDERObject() {
        if (this.id instanceof SubjectKeyIdentifier) {
            return new BERTaggedObject(false, 0, this.id.getDERObject());
        }
        return this.id.getDERObject();
    }

    private void setId(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.id = issuerAndSerialNumber;
    }

    private void setId(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.id = subjectKeyIdentifier;
    }
}

