/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Calendar;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.Time;

public class SigningTimeAttribute
extends Attribute {
    protected SigningTimeAttribute() {
        this.attrType = CMSObjectIdentifiers.id_signingTime;
    }

    public SigningTimeAttribute(ASN1Sequence aSN1Sequence) {
        this();
        this.attrValues = (DERConstructedSet)aSN1Sequence.getObjectAt(1);
    }

    public SigningTimeAttribute(Attribute attribute) {
        this();
        this.attrValues = attribute.attrValues;
    }

    public SigningTimeAttribute(Date date) {
        this();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(1);
        if (n < 1950 || n > 2059) {
            this.setTime(Time.getInstance(new DERGeneralizedTime(date)));
        } else {
            this.setTime(Time.getInstance(new DERUTCTime(date)));
        }
    }

    public SigningTimeAttribute(SigningTimeAttribute signingTimeAttribute) {
        this();
        this.attrValues = signingTimeAttribute.attrValues;
    }

    public SigningTimeAttribute(Time time) {
        this();
        this.setTime(time);
    }

    public static Attribute getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SigningTimeAttribute.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static Attribute getInstance(Object object) {
        if (object == null || object instanceof SigningTimeAttribute) {
            return (SigningTimeAttribute)object;
        }
        if (object instanceof Attribute) {
            return new SigningTimeAttribute((Attribute)object);
        }
        if (object instanceof ASN1Sequence) {
            return new SigningTimeAttribute((ASN1Sequence)object);
        }
        return new SigningTimeAttribute(Time.getInstance(object));
    }

    public Time getTime() {
        return Time.getInstance(this.attrValues.getObjectAt(0));
    }

    private void setTime(Time time) {
        this.attrValues = new DERConstructedSet();
        this.attrValues.addObject(time);
    }
}

