/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSObject;

public class UnsignedAttributes
extends CMSObject {
    private ASN1Set attributes;

    public UnsignedAttributes(Vector vector) {
        this.setAttributes(vector);
    }

    public UnsignedAttributes(ASN1Set aSN1Set) {
        this.attributes = aSN1Set;
    }

    public UnsignedAttributes(UnsignedAttributes unsignedAttributes) {
        this.attributes = unsignedAttributes.attributes;
    }

    public static UnsignedAttributes getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return UnsignedAttributes.getInstance(ASN1Set.getInstance(aSN1TaggedObject, bl));
    }

    public static UnsignedAttributes getInstance(Object object) {
        if (object == null || object instanceof UnsignedAttributes) {
            return (UnsignedAttributes)object;
        }
        if (object instanceof Vector) {
            return new UnsignedAttributes((Vector)object);
        }
        if (object instanceof ASN1Set) {
            return new UnsignedAttributes((ASN1Set)object);
        }
        throw new IllegalArgumentException("Invalid UnsignedAttributes: " + object.getClass().getName());
    }

    public Vector getAttributes() {
        int n = this.attributes.getSize();
        Vector<Attribute> vector = new Vector<Attribute>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(Attribute.getInstance(this.attributes.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    public DERObject getDERObject() {
        return this.attributes;
    }

    private void setAttributes(Vector vector) {
        int n = vector.size();
        this.attributes = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.attributes.addObject(Attribute.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }
}

