/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.smime;

import java.util.Vector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMEObjectIdentifiers;

public class SMIMECapabilitiesAttribute
extends Attribute {
    public SMIMECapabilitiesAttribute() {
        this.attrType = SMIMEObjectIdentifiers.smimeCapabilities;
    }

    public SMIMECapabilitiesAttribute(ASN1Sequence aSN1Sequence) {
        this();
        this.attrValues = (DERConstructedSet)aSN1Sequence.getObjectAt(1);
    }

    public SMIMECapabilitiesAttribute(SMIMECapabilitiesAttribute sMIMECapabilitiesAttribute) {
        this();
        this.attrValues = sMIMECapabilitiesAttribute.attrValues;
    }

    public static Attribute getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SMIMECapabilitiesAttribute.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static Attribute getInstance(Object object) {
        if (object == null || object instanceof SMIMECapabilitiesAttribute) {
            return (SMIMECapabilitiesAttribute)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SMIMECapabilitiesAttribute((ASN1Sequence)object);
        }
        if (object instanceof ASN1TaggedObject) {
            return SMIMECapabilitiesAttribute.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SMIMECapabilitiesAttribute: " + object.getClass().getName());
    }

    public void addCapability(SMIMECapability sMIMECapability) {
        ASN1Sequence aSN1Sequence;
        if (this.attrValues == null) {
            this.attrValues = new DERConstructedSet();
        }
        if (this.attrValues.getSize() == 0) {
            aSN1Sequence = new BERConstructedSequence();
            this.attrValues.addObject(aSN1Sequence);
        } else {
            aSN1Sequence = (ASN1Sequence)this.attrValues.getObjectAt(0);
        }
        aSN1Sequence.addObject(sMIMECapability);
    }

    public Vector getCapabilities() {
        Vector<SMIMECapability> vector = new Vector<SMIMECapability>();
        ASN1Sequence aSN1Sequence = (ASN1Sequence)this.attrValues.getObjectAt(0);
        int n = 0;
        while (n < aSN1Sequence.getSize()) {
            vector.addElement(SMIMECapability.getInstance(aSN1Sequence.getObjectAt(n)));
            ++n;
        }
        return vector;
    }
}

